Attribute VB_Name = "modMakeMDB"
'-------------------------------------------------------------
'// This module creates the database "Clients.mdb" on the fly
'// and loads the "Country" table
'-------------------------------------------------------------
Option Explicit

Public Sub MakeDataBase()
Dim oCat As ADOX.Catalog
Dim oTbl As ADOX.Table
Dim cMDBName As String
    cMDBName = App.Path & _
    IIf(Right$(App.Path, 1) <> "\", "\", "") & _
    "Clients.mdb"

Set oCat = New ADOX.Catalog
If Dir(cMDBName) = "" Then
   oCat.Create "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & cMDBName
Else
   Exit Sub
End If

oCat.ActiveConnection = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & cMDBName

' =====================================
' ============= Tables  ===============
' =====================================

Set oTbl = New ADOX.Table
oTbl.Name = "Appointments"
oCat.Tables.Append oTbl
Set oTbl = New ADOX.Table
oTbl.Name = "Clients"
oCat.Tables.Append oTbl
Set oTbl = New ADOX.Table
oTbl.Name = "Country"
oCat.Tables.Append oTbl

    MakeColumns oCat
    MakeIndexes oCat
    MakeKeys oCat

Set oCat.ActiveConnection = Nothing
Set oCat = Nothing
Set oTbl = Nothing
Call LoadCountryData

End Sub 'MakeTables()
'-----------------------------------------------------------------
Private Sub MakeColumns(ByRef oCat As ADOX.Catalog)
' =====================================
' ============= Columns ===============
' =====================================

    MakeColumns_Appointments oCat
    MakeColumns_Clients oCat
    MakeColumns_Country oCat

End Sub ' MakeColumns()
'-----------------------------------------------------------------
Private Sub MakeColumns_Appointments(ByRef oCat As ADOX.Catalog)
Dim oCol As ADOX.Column
    Set oCol = New ADOX.Column

    Set oCol = New ADOX.Column
    With oCol
        .Name = "ID"
        .Precision = 10
        .Type = adInteger
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Autoincrement").Value = True
        .Properties("Default").Value = "GenUniqueID()"
        .Properties("Fixed Length").Value = True
    End With
    oCat.Tables("Appointments").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "ClientID"
        .Precision = 10
        .Type = adInteger
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Default").Value = 0
        .Properties("Fixed Length").Value = True
    End With
    oCat.Tables("Appointments").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "fromTime"
        .Type = adDate
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Fixed Length").Value = True
    End With
    oCat.Tables("Appointments").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "untilTime"
        .DefinedSize = 50
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Appointments").Columns.Append oCol
Set oCol = Nothing
End Sub 'MakeColumns_Appointments(ByRef oCat As ADOX.Catalog)
'-----------------------------------------------------------------
Private Sub MakeColumns_Clients(ByRef oCat As ADOX.Catalog)
Dim oCol As ADOX.Column
    Set oCol = New ADOX.Column

    Set oCol = New ADOX.Column
    With oCol
        .Name = "ID"
        .Precision = 10
        .Type = adInteger
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Autoincrement").Value = True
        .Properties("Fixed Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Last Name"
        .DefinedSize = 30
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "First Name"
        .DefinedSize = 30
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Street"
        .DefinedSize = 40
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "ZIP"
        .DefinedSize = 10
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "City"
        .DefinedSize = 30
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Country"
        .Precision = 10
        .Type = adInteger
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Default").Value = 0
        .Properties("Description").Value = "Combo|SELECT ID, Name FROM Country"
        .Properties("Fixed Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Home phone"
        .DefinedSize = 30
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Office phone"
        .DefinedSize = 30
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Cell phone"
        .DefinedSize = 30
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "email address"
        .DefinedSize = 40
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Compressed UNICODE Strings").Value = True
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Clients").Columns.Append oCol
Set oCol = Nothing
End Sub 'MakeColumns_Clients(ByRef oCat As ADOX.Catalog)
'-----------------------------------------------------------------
Private Sub MakeColumns_Country(ByRef oCat As ADOX.Catalog)
Dim oCol As ADOX.Column
    Set oCol = New ADOX.Column

    Set oCol = New ADOX.Column
    With oCol
        .Name = "ID"
        .Precision = 10
        .Type = adInteger
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Autoincrement").Value = True
        .Properties("Fixed Length").Value = True
    End With
    oCat.Tables("Country").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Name"
        .DefinedSize = 20
    Set .ParentCatalog = oCat
        .Properties.Refresh
    End With
    oCat.Tables("Country").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Abbreviation"
        .DefinedSize = 5
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Country").Columns.Append oCol

    Set oCol = New ADOX.Column
    With oCol
        .Name = "Prefix"
        .DefinedSize = 8
    Set .ParentCatalog = oCat
        .Properties.Refresh
        .Properties("Jet OLEDB:Allow Zero Length").Value = True
    End With
    oCat.Tables("Country").Columns.Append oCol
Set oCol = Nothing
End Sub 'MakeColumns_Country(ByRef oCat As ADOX.Catalog)
'-----------------------------------------------------------------
Private Sub MakeIndexes(ByRef oCat As ADOX.Catalog)
Dim oIdx As ADOX.Index
' =====================================
' ============= Indexes ===============
' =====================================


    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "PrimaryKey"
        .PrimaryKey = True
        .Unique = True
        .Properties.Refresh
        .Columns.Append "ID"
        .Columns("ID").SortOrder = adSortAscending
    End With
    oCat.Tables("Appointments").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "ID"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "ID"
        .Columns("ID").SortOrder = adSortAscending
    End With
    oCat.Tables("Appointments").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "PatientID"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "ClientID"
        .Columns("ClientID").SortOrder = adSortAscending
    End With
    oCat.Tables("Appointments").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "PRIMARYKEY"
        .PrimaryKey = True
        .Unique = True
        .Properties.Refresh
        .Columns.Append "ID"
        .Columns("ID").SortOrder = adSortAscending
    End With
    oCat.Tables("Clients").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "NAME"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "Last Name"
        .Columns("Last Name").SortOrder = adSortAscending
    End With
    oCat.Tables("Clients").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "Name"
        .IndexNulls = adIndexNullsAllow
        .Unique = True
        .Properties.Refresh
        .Columns.Append "Name"
        .Columns("Name").SortOrder = adSortAscending
    End With
    oCat.Tables("Country").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "PrimaryKey"
        .PrimaryKey = True
        .Unique = True
        .Properties.Refresh
        .Columns.Append "ID"
        .Columns("ID").SortOrder = adSortAscending
    End With
    oCat.Tables("Country").Indexes.Append oIdx
Set oIdx = Nothing
End Sub ' MakeIndexes()
'-----------------------------------------------------------------
Private Sub MakeKeys(ByRef oCat As ADOX.Catalog)
Dim oKey As ADOX.Key
' =====================================
' ============= Keys    ===============
' =====================================


    Set oKey = New ADOX.Key
    With oKey
        .Name = "PatientsAppointments"
        .Type = adKeyForeign
        .DeleteRule = adRINone
        .RelatedTable = "Clients"
        .UpdateRule = adRINone
        .Columns.Append "ClientID"
        .Columns("ClientID").RelatedColumn = "ID"
    End With
    oCat.Tables("Appointments").Keys.Append oKey
Set oKey = Nothing
End Sub 'MakeKeys()
Private Sub LoadCountryData()
Dim oCon As ADODB.Connection
Set oCon = New ADODB.Connection
Dim cMDBName As String
    cMDBName = App.Path & _
    IIf(Right$(App.Path, 1) <> "\", "\", "") & _
     "Clients.mdb"
With oCon
  .ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & cMDBName
  .Open
  .CursorLocation = adUseServer
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Ukraine','UA','380')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Slovakia','SLO','42')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Estonia','EE','372')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Croatia','HR','385')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Serbia-Montenegro','SRB','381')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Lithuania','LT','370')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Sudan','EAS','249')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Burkina Faso','BF','226')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Rwanda','RW','250')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Gabon','','241')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Burundi','','257')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Oman','','968')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Uganda','EAU','256')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Ghana','GH','233')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Andorra','AND','376')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Belgium','B','32')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Germany','D','49')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Bulgaria','BG','359')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Czech Republic','CS','42')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Denmark','DK','45')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('German Democratic R.','DDR','49')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Ireland','IRL','353')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Finland','SF','358')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Greece','GR','30')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Great Britain','GB','44')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Iceland','IS','354')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Italy','I','39')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Yugoslavia','YU','')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Liechtenstein','FL','4175')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Luxembourg','L','352')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Malta','M','356')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Monaco','MC','3393')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Netherlands','NL','31')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Norway','N','47')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Poland','PL','48')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Austria','A','43')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Portugal','P','351')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Rumania','R','40')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Sweden','S','46')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Switzerland','CH','41')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Community of Ind. St','CIS','7')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Spain','E','34')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Turkey','TR','90')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Hungary','H','36')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Cyprus','CY','357')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('U.S.A.','USA','1')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Canada','CDN','1')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('India','IND','91')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Israel','IL','972')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('France','F','33')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Algeria','DZ','213')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Angola','','244')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Bahrain','BRN','973')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Botswana','RB','267')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Chad','','235')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Egypt','ET','20')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Ethiopia','ETH','251')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Guinea','','224')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Iran','IR','98')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Iraq','IRQ','964')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Jordan','JOR','962')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Kenya','EAK','254')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Lebanon','LIBAN','961')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Lybia','LAR','218')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Madagascar','RM','261')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Morocco','MA','212')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Mozambique','','258')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Pakistan','PAK','92')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Saudia Arabia','SA','966')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('South Africa','ZA','27')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Syria','SYR','963')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Tanzania','EAT','255')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Tunisia','TN','216')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Zaire','CGO','243')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Zambia','Z','260')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('China (Peoples Repu)','TJ','86')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Argentina','RA','54')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Chile','RCH','56')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Columbia','CO','57')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Mexico','ME','52')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Venezuela','YV','58')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('New Zealand','NZ','64')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('South Korea','ROK','82')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Japan','J','81')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Nigeria','WAN','234')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Kuwait','KWT','965')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('United Arab Emirates','UAE','971')", , adCmdText + adExecuteNoRecords
  .Execute "INSERT INTO Country (Name, Abbreviation, Prefix) Values ('Congo, P.R.','RCB','242')", , adCmdText + adExecuteNoRecords
  .Close
End With
Set oCon = Nothing

End Sub


