Attribute VB_Name = "Module1"
Option Explicit

'------------------------------------------------------------
' The 16 Bit SendMessage API uses these values:
'Public Const WM_USER = &H400                        ' = 1024
'Public Const LB_SETHORIZONTALEXTENT = WM_USER + 21  ' = 1045
'Public Const LB_SETTABSTOPS = WM_USER + 19          ' = 1043
'------------------------------------------------------------
'Public Declare Function SendMessage Lib "user" _
                        ( _
                        ByVal hWnd As Integer, _
                        ByVal wMsg As Integer, _
                        ByVal wParam As Integer, _
                        lParam As Any _
                        ) As Long

'------------------------------------------------------------
' The SetWindowPos API uses these values:
Public Const HWND_NOTOPMOST = -2
Public Const HWND_TOPMOST = -1
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOSIZE = &H1
'------------------------------------------------------------

'------------------------------------------------------------
' The 32 Bit SendMessage API uses these values:
Public Const LB_SETTABSTOPS = &H192                 ' =  402
Public Const LB_SETHORIZONTALEXTENT = &H194         ' =  404
Public Const EM_SETTABSTOPS = &HCB                  ' =  203
'------------------------------------------------------------
Public Declare Function SendMessage Lib "User32" _
                        Alias "SendMessageA" ( _
                        ByVal hWnd As Long, _
                        ByVal wMsg As Long, _
                        ByVal wParam As Long, lParam As Any _
                        ) As Long

' We use this API in the frmAbout Form to send an email to the author:
Declare Function ShellExecute Lib "shell32.dll" _
                        Alias "ShellExecuteA" ( _
                        ByVal hWnd As Long, _
                        ByVal lpOperation As String, _
                        ByVal lpFile As String, _
                        ByVal lpParameters As String, _
                        ByVal lpDirectory As String, _
                        ByVal nShowCmd As Long _
                        ) As Long

' We use this API in the frmAbout Form to keep the form "always on top":
Declare Sub SetWindowPos Lib "User32" ( _
                        ByVal hWnd As Long, _
                        ByVal hWndInsertAfter As Long, _
                        ByVal X As Long, _
                        ByVal Y As Long, _
                        ByVal cx As Long, _
                        ByVal cy As Long, _
                        ByVal wFlags As Long _
                        )
                        
Public Type BCS_FormFontValues
  ' Temporary variables to preserve form font settings:
    fontname As String
    fontsize As Integer
    fontbold As Boolean
    fontitalic As Boolean
    fontstrikethru As Boolean
    fontunderline  As Boolean
End Type


' "Tab stops in a list box are specified in dialog box units, not pixels or
'  character position [or twips]. Essentially, a dialog box unit is used by
'  Windows to size a control based on the average character width of the current
'  system font. This average character width is called the dialog box base
'  unit, and 1 dialog box base unit equals 4 dialog box units (1:4 ratio)."

' This code will create a tabbed listbox with columns from a recordset neatly
' aligned. Note that the recordset does NOT need to come from a database; rather,
' it could be created "on the fly" in the Sub which calls the sub below. There
' is one problem I could not solve: how to "freeze" the column headings. I tried
' placing a PictureBox above the ListBox but the conversion of the Tab Stops
' which are calculated below (and are in dialog box units) into twips needed
' for the PictureBox proved to be less than 100% accurate. Suggestions gladly
' accepted at <ThomasOBascom@compuserve.de>

Public Sub Q115712(lb As ListBox, oRs As Recordset, frm As Form, nBlanksBetweenCols As Integer)
On Error GoTo CannotDisplay

     Dim whiteSpace As Integer
     Dim AccumTabStops As Integer
     Dim dialogUnits As Integer
     Dim fieldVal As String
     Dim ListLine As String
     Dim avgWidth As Single
     Dim retval As Long
     Dim i As Integer
     Dim nMaxColWidth_DialogUnits() As Single
     Dim TabStops() As Long         ' KB article Q115712 Dims this as an Integer
                                    ' because the 16 Bit version of the SendMessage
                                    ' API requires an integer value for the wParam
                                    ' parameter
     

    
    ' Save form's font settings so we can use the form to calculate the
    ' TextWidth / Height of the strings to go into the list box.
     

     Dim oldFont As BCS_FormFontValues
     Call SaveFormFontValues(oldFont, frm)
     
     With frm
         ' Set form font settings to be identical to list box.
         .fontname = lb.fontname
         .fontsize = lb.fontsize
         .fontbold = lb.fontbold
         .fontitalic = lb.fontitalic
         .fontstrikethru = lb.fontstrikethru
         .fontunderline = lb.fontunderline
     End With
     
     ' "Get the average character width of the current list box font
     ' (in pixels) using the form's TextWidth width method."
     
     ' The frm.TextWidth() returns a value in terms of the ScaleMode
     ' property of the form. The default is twips:
     avgWidth = frm.TextWidth("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
     
     ' Now convert to pixels and get the average width of each
     ' character in the 52 letter alphabet:
     avgWidth = (avgWidth / Screen.TwipsPerPixelX) / 52

     ' "Set the white space you want between columns." (pixels)
     whiteSpace = avgWidth * nBlanksBetweenCols

     ReDim nMaxColWidth_DialogUnits(0 To oRs.Fields.Count - 1)
     ReDim TabStops(1 To oRs.Fields.Count)
     
     ' Clear all items from the ListBox:
     lb.Clear


     
     ' Loop through the field names.
     ' Calculate the width required for that field name
     ' We do this in case the field name is wider than
     ' its content:
     
     ListLine = ""
     For i = 0 To oRs.Fields.Count - 1
       fieldVal = oRs(i).Name

       dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
       If dialogUnits > nMaxColWidth_DialogUnits(i) Then
         nMaxColWidth_DialogUnits(i) = dialogUnits
       End If
       ListLine = ListLine & fieldVal & vbTab
     
     Next
     lb.AddItem ListLine    ' add the column heading
     ListLine = ""

     
     ' "Loop through the field values for each record in the [recordset].
     '  Calculate the width required for that field value to fit in the list
     '  box. Also, build each line of the list box and add it to the list as
     '  you go."
     Do Until oRs.EOF

       For i = 0 To oRs.Fields.Count - 1
         fieldVal = oRs(i) & ""       ' Append "" in case of a null field.
         fieldVal = Replace(fieldVal, vbCrLf, " ")
        ' "The LB_SETTABSTOP message requires coordinates in dialog
        '  units; (roughly 4 *, the average character width in pixels)."
        
        ' "NOTE: The example code assumes that the form's scale mode is the default
        '  Twips. If the scale mode is set to pixels, then the division by
        '  screen.TwipsPerPixelX is extraneous and should be removed. Also note
        '  that you could use the TextWidth method of a picture control if you
        '  didn 't want to change the font properties of the form."

         dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
         If dialogUnits > nMaxColWidth_DialogUnits(i) Then
           nMaxColWidth_DialogUnits(i) = dialogUnits
         End If
        
        ListLine = ListLine & fieldVal & "" & vbTab
       
       Next i
       
       lb.AddItem ListLine
       ListLine = ""
       oRs.MoveNext
     Loop
     

     ' Fill the tabstops() array with the position of each tab stop.
     For i = 0 To oRs.Fields.Count - 1
       AccumTabStops = AccumTabStops + nMaxColWidth_DialogUnits(i)
       TabStops(i + 1) = AccumTabStops
     Next i
     
     
     oRs.MoveFirst
     
     '  Clear any existing TabStops:
        Call SendMessage(lb.hWnd, LB_SETTABSTOPS, 0&, ByVal 0&)

     
     ' "Send LB_SETTABSTOP to the list box to set the position of each column."
        Call SendMessage(lb.hWnd, LB_SETTABSTOPS, UBound(TabStops), TabStops(1))

     
     ' "Set the horizontal extent just wider than the first tab stop.
     '  This will produce a horizontal scroll bar on the list box.
     '  This message requires coordinates in pixels, so we convert the tab
     '  stop coordinate back from dialog units to pixels."
        Call SendMessage(lb.hWnd, LB_SETHORIZONTALEXTENT, (TabStops(UBound(TabStops)) \ 4) * avgWidth, 0&)

     ' Restore form's original font property settings.
     Call RestoreFormFontValues(oldFont, frm)
     
     Exit Sub

CannotDisplay:
Call RestoreFormFontValues(oldFont, frm)
MsgBox "Unable to display the" & vbCrLf & _
       "ListBox with the current" & vbCrLf & _
       "recordset. Please make sure" & vbCrLf & _
       "that the recordset does not" & vbCrLf & _
       "contain OLE or Memo fields", vbCritical + vbOKOnly

End Sub


Private Sub SaveFormFontValues(ByRef fntStru As BCS_FormFontValues, frm As Form)

    With fntStru
     .fontbold = frm.fontbold
     .fontitalic = frm.fontitalic
     .fontname = frm.fontname
     .fontsize = frm.fontsize
     .fontstrikethru = frm.fontstrikethru
     .fontunderline = frm.fontunderline
    End With


End Sub
Private Sub RestoreFormFontValues(ByRef fntStru As BCS_FormFontValues, frm As Form)

    With frm
     .fontbold = fntStru.fontbold
     .fontitalic = fntStru.fontitalic
     .fontname = fntStru.fontname
     .fontsize = fntStru.fontsize
     .fontstrikethru = fntStru.fontstrikethru
     .fontunderline = fntStru.fontunderline
    End With

End Sub

