Attribute VB_Name = "modCreateMDB"
Public Sub CreateMDB()
Dim OurMDB As String
Dim OurPath
OurPath = App.Path & IIf(Right$(App.Path, 1) <> "\", "\", "")
OurMDB = OurPath & "SouthWind.mdb"

If Dir(OurMDB) = "" And _
   Dir(OurPath & "customers.txt") <> "" And _
   Dir(OurPath & "schema.ini") <> "" Then
    '--------------------------------------------------------
    ' Create the Access database:
    '--------------------------------------------------------

    Dim oCat As ADOX.Catalog
    Set oCat = New ADOX.Catalog
    Dim oTbl As ADOX.Table
    Dim sSQL As String
    oCat.Create "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & OurMDB
   
    Set oCat.ActiveConnection = Nothing
    
    '--------------------------------------------------------
    ' Create & Load the Customers table
    ' Using the customers.txt file and
    ' schema.ini file located in this
    ' subdirectory. Notice the delimiter
    ' used in the customers.txt file AND
    ' the entry in the schema.ini file:
    '      Format = Delimited(|)
    '--------------------------------------------------------

    Dim oCon As ADODB.Connection
    Set oCon = New ADODB.Connection
    sCon = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
           "Data Source=" & Left$(OurPath, Len(OurPath) - 1) & ";" & _
           "Extended Properties=Text"
    
    With oCon
     .ConnectionString = sCon
     .Open


      sSQL = "SELECT * " & _
             "Into [Customers] " & _
             "IN '" & OurMDB & "' " & _
             "From [Customers.txt]"
    

      .Execute sSQL
      .Close
      
    End With
    Set oCon = Nothing
    
    '--------------------------------------------------------
    ' Create some indexes
    '--------------------------------------------------------
    
    oCat.ActiveConnection = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & OurMDB
    Call MakeIndexes_Customers(oCat)
    Set oCat.ActiveConnection = Nothing
    Set oCat = Nothing

End If

End Sub


Private Sub MakeIndexes_Customers(ByRef oCat As ADOX.Catalog)
'--------------------------------------------------------
' This code was created using a "clone" utility
' which analyses Tables, Indexes and Keys of
' an existing MDB
'--------------------------------------------------------

Dim oIdx As ADOX.Index


    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "PrimaryKey"
        .PrimaryKey = True
        .Unique = True
        .Properties.Refresh
        .Columns.Append "CustomerID"
        .Columns("CustomerID").SortOrder = adSortAscending
    End With
    oCat.Tables("Customers").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "City"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "City"
        .Columns("City").SortOrder = adSortAscending
    End With
    oCat.Tables("Customers").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "CompanyName"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "CompanyName"
        .Columns("CompanyName").SortOrder = adSortAscending
    End With
    oCat.Tables("Customers").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "PostalCode"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "PostalCode"
        .Columns("PostalCode").SortOrder = adSortAscending
    End With
    oCat.Tables("Customers").Indexes.Append oIdx

    Set oIdx = New ADOX.Index
    With oIdx
        .Name = "Region"
        .IndexNulls = adIndexNullsAllow
        .Properties.Refresh
        .Columns.Append "Region"
        .Columns("Region").SortOrder = adSortAscending
    End With
    oCat.Tables("Customers").Indexes.Append oIdx

End Sub

