VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "JET Data Export Machine"
   ClientHeight    =   6870
   ClientLeft      =   45
   ClientTop       =   615
   ClientWidth     =   10380
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6870
   ScaleWidth      =   10380
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.FileListBox FlbSource 
      Height          =   2235
      Index           =   1
      Left            =   600
      MultiSelect     =   1  '1 -Einfach
      TabIndex        =   6
      Top             =   4320
      Width           =   2535
   End
   Begin VB.FileListBox FlbSource 
      Height          =   2235
      Index           =   0
      Left            =   120
      TabIndex        =   4
      Top             =   3960
      Width           =   2535
   End
   Begin VB.DirListBox DirSource 
      Height          =   1665
      Left            =   120
      TabIndex        =   3
      Top             =   1920
      Width           =   2535
   End
   Begin VB.DriveListBox DrvSource 
      Height          =   315
      Left            =   120
      TabIndex        =   1
      Top             =   1200
      Width           =   2535
   End
   Begin VB.ComboBox cmbSourceFormat 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown-Liste
      TabIndex        =   0
      Top             =   480
      Width           =   2535
   End
   Begin VB.Frame Frame1 
      Caption         =   "Text Export Specifications"
      Enabled         =   0   'False
      Height          =   5175
      Left            =   5520
      TabIndex        =   13
      Top             =   120
      Width           =   4695
      Begin VB.ComboBox cmbFieldDelimit 
         Height          =   315
         Left            =   2760
         Style           =   2  'Dropdown-Liste
         TabIndex        =   38
         Top             =   4680
         Width           =   1695
      End
      Begin VB.CheckBox chkLeadingZeros 
         Alignment       =   1  'Rechts ausgerichtet
         Caption         =   "Leading zeros for values < 1"
         Height          =   255
         Left            =   180
         TabIndex        =   36
         Top             =   4320
         Value           =   1  'Aktiviert
         Width           =   2775
      End
      Begin VB.CheckBox chkHeaders 
         Alignment       =   1  'Rechts ausgerichtet
         Caption         =   "Include field names in header: "
         Height          =   255
         Left            =   180
         TabIndex        =   15
         Top             =   240
         Value           =   1  'Aktiviert
         Width           =   2775
      End
      Begin VB.TextBox txtNonCurrDecSym 
         Height          =   285
         Left            =   2760
         MaxLength       =   1
         TabIndex        =   35
         Text            =   "."
         Top             =   3840
         Width           =   375
      End
      Begin VB.TextBox txtDecimalsNonCurrency 
         Height          =   285
         Left            =   2760
         MaxLength       =   1
         TabIndex        =   33
         Text            =   "2"
         Top             =   3480
         Width           =   375
      End
      Begin VB.TextBox txtCurrThouSep 
         Height          =   285
         Left            =   2760
         MaxLength       =   1
         TabIndex        =   31
         Text            =   ","
         Top             =   3120
         Width           =   375
      End
      Begin VB.TextBox txtCurrDecSym 
         Height          =   285
         Left            =   2760
         MaxLength       =   1
         TabIndex        =   29
         Text            =   "."
         Top             =   2760
         Width           =   375
      End
      Begin VB.ComboBox cmbNegCurrFmt 
         Height          =   315
         Left            =   2760
         Style           =   2  'Dropdown-Liste
         TabIndex        =   27
         Top             =   2400
         Width           =   1815
      End
      Begin VB.ComboBox cmbPosCurrFmt 
         Height          =   315
         Left            =   2760
         Style           =   2  'Dropdown-Liste
         TabIndex        =   25
         Top             =   2040
         Width           =   1815
      End
      Begin VB.TextBox txtDecimalsCurrency 
         Height          =   285
         Left            =   2760
         MaxLength       =   1
         TabIndex        =   23
         Text            =   "2"
         Top             =   1680
         Width           =   375
      End
      Begin VB.TextBox txtCurrencySymbol 
         Height          =   285
         Left            =   2760
         MaxLength       =   3
         TabIndex        =   21
         Text            =   "$"
         Top             =   1320
         Width           =   615
      End
      Begin VB.ComboBox cmbCharSet 
         Height          =   315
         Left            =   2760
         Style           =   2  'Dropdown-Liste
         TabIndex        =   19
         Top             =   960
         Width           =   1215
      End
      Begin VB.ComboBox cmbDateTime 
         Height          =   315
         Left            =   2760
         TabIndex        =   17
         Top             =   600
         Width           =   1455
      End
      Begin VB.Label Label2 
         Caption         =   "Format:"
         Height          =   255
         Index           =   10
         Left            =   240
         TabIndex        =   37
         Top             =   4800
         Width           =   1335
      End
      Begin VB.Label Label2 
         Caption         =   "Decimal symbol (non-currency):"
         Height          =   255
         Index           =   9
         Left            =   240
         TabIndex        =   34
         Top             =   3960
         Width           =   2295
      End
      Begin VB.Label Label2 
         Caption         =   "Decimal places (non-currency):"
         Height          =   255
         Index           =   8
         Left            =   240
         TabIndex        =   32
         Top             =   3600
         Width           =   2295
      End
      Begin VB.Label Label2 
         Caption         =   "Thousands separator (currency):"
         Height          =   255
         Index           =   7
         Left            =   240
         TabIndex        =   30
         Top             =   3240
         Width           =   2415
      End
      Begin VB.Label Label2 
         Caption         =   "Decimal symbol (currency):"
         Height          =   255
         Index           =   6
         Left            =   240
         TabIndex        =   28
         Top             =   2880
         Width           =   1935
      End
      Begin VB.Label Label2 
         Caption         =   "Negative format (currency):"
         Height          =   255
         Index           =   5
         Left            =   240
         TabIndex        =   26
         Top             =   2520
         Width           =   1935
      End
      Begin VB.Label Label2 
         Caption         =   "Positive format (currency):"
         Height          =   255
         Index           =   4
         Left            =   240
         TabIndex        =   24
         Top             =   2160
         Width           =   1935
      End
      Begin VB.Label Label2 
         Caption         =   "Decimal places (currency):"
         Height          =   255
         Index           =   3
         Left            =   240
         TabIndex        =   22
         Top             =   1800
         Width           =   1935
      End
      Begin VB.Label Label2 
         Caption         =   "Currency Symbol"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   20
         Top             =   1440
         Width           =   1335
      End
      Begin VB.Label Label2 
         Caption         =   "Character Set:"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   18
         Top             =   1080
         Width           =   1335
      End
      Begin VB.Label Label2 
         Caption         =   "Date Time Format:"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   16
         Top             =   720
         Width           =   1335
      End
   End
   Begin VB.TextBox txtSQLStatement 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   5520
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Beides
      TabIndex        =   42
      Top             =   5400
      Width           =   4695
   End
   Begin VB.DirListBox DirTarget 
      Height          =   1665
      Left            =   2880
      TabIndex        =   12
      Top             =   1920
      Width           =   2535
   End
   Begin VB.DriveListBox DrvTarget 
      Height          =   315
      Left            =   2880
      TabIndex        =   10
      Top             =   1200
      Width           =   2535
   End
   Begin VB.CommandButton cmdExport 
      Caption         =   "&Export"
      Enabled         =   0   'False
      Height          =   315
      Left            =   2520
      TabIndex        =   11
      Top             =   6480
      Width           =   855
   End
   Begin VB.ComboBox cmbExportFormat 
      Height          =   315
      Left            =   2880
      Sorted          =   -1  'True
      Style           =   2  'Dropdown-Liste
      TabIndex        =   8
      Top             =   480
      Width           =   2535
   End
   Begin VB.ListBox LstTables 
      Enabled         =   0   'False
      Height          =   2205
      ItemData        =   "frmExport.frx":0000
      Left            =   2880
      List            =   "frmExport.frx":0002
      MultiSelect     =   1  '1 -Einfach
      TabIndex        =   14
      Top             =   3960
      Visible         =   0   'False
      Width           =   2535
   End
   Begin VB.Label Label1 
      Caption         =   "Tables, Queries/Named Ranges:"
      Height          =   255
      Index           =   0
      Left            =   2880
      TabIndex        =   43
      Top             =   3720
      Visible         =   0   'False
      Width           =   2415
   End
   Begin VB.Label Label1 
      Caption         =   "Source folder:"
      Height          =   255
      Index           =   7
      Left            =   120
      TabIndex        =   41
      Top             =   1680
      Width           =   1455
   End
   Begin VB.Label Label1 
      Caption         =   "Destination drive:"
      Height          =   255
      Index           =   6
      Left            =   120
      TabIndex        =   40
      Top             =   960
      Width           =   1455
   End
   Begin VB.Label Label1 
      Caption         =   "Source Format:"
      Height          =   255
      Index           =   5
      Left            =   120
      TabIndex        =   39
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Destination folder:"
      Height          =   255
      Index           =   4
      Left            =   2880
      TabIndex        =   9
      Top             =   1680
      Width           =   1455
   End
   Begin VB.Label Label1 
      Caption         =   "Destination drive:"
      Height          =   255
      Index           =   3
      Left            =   2880
      TabIndex        =   7
      Top             =   960
      Width           =   1455
   End
   Begin VB.Label Label1 
      Caption         =   "Tables:"
      Height          =   255
      Index           =   2
      Left            =   120
      TabIndex        =   5
      Top             =   3720
      Width           =   2415
   End
   Begin VB.Label Label1 
      Caption         =   "Target Format:"
      Height          =   255
      Index           =   1
      Left            =   2880
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin VB.Menu oFile 
      Caption         =   "&File"
      Begin VB.Menu oAbout 
         Caption         =   "&About"
      End
      Begin VB.Menu oExit 
         Caption         =   "&Exit"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'------------------------------------------------------------------------------
'  Compliments of Toby Bascom
'  email:         ThomasOBascom@compuserve.de
'  Web site:      http://www.carpet-sharks.com
'------------------------------------------------------------------------------

Option Explicit
Private cConStr As String           ' Connection String used to connect to the data source
Private cDataSource As String       ' The Data Source
Private cLinkFile As String         ' The Access 2000 file we'll use for creating links to non-access
                                    ' tables
Private cExtendedProps As String    ' optional Extended Properties used in the Connection String
Private nFlbInUse As Integer        ' Either 0 or 1; index of the FileListBox (FlbSource) in use

'  We'll use this API in conjuction with the
' "RepairAndCompact" sub:
Private Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" ( _
                                                          ByVal nBufferLength As Long, _
                                                          ByVal lpBuffer As String _
                                                                         ) As Long
' Instead of using the DrvTarget DirTarget controls for navigating
' to a target directory, we could have used the "SHBrowseForFolder" API

Dim nHdnlToolTip(1 To 10) As Long
Private Sub Form_Unload(Cancel As Integer)

' See the modPublic.bas module
' "CreateToolTip()" sub. The customized
' tooltips allow multiple line text.
' We need to destroy the tooltip handles
' created in the Form_Load() event:

Dim n As Integer
For n = LBound(nHdnlToolTip) To UBound(nHdnlToolTip)
 DestroyWindow nHdnlToolTip(n)
Next

End Sub

Private Sub Form_Load()
cLinkFile = App.Path & IIf(Right$(App.Path, 1) <> "\", "\", "") & "interface.tob"

'--------------------------------------------------------
' Set up the custom tooltips used throughout the program:
'--------------------------------------------------------
Call CreateToolTip(nHdnlToolTip(1), Me.hwnd, _
                  Me.cmbSourceFormat, _
                  "Select the file type" & vbCrLf & "you want to export FROM" _
                  )
Call CreateToolTip(nHdnlToolTip(2), Me.hwnd, _
                  Me.FlbSource(0), _
                  "Left click 1x on a file to see" & vbCrLf & "the tables contained in the file" _
                  )

Call CreateToolTip(nHdnlToolTip(3), Me.hwnd, _
                  Me.FlbSource(1), _
                  "Select/deselect with <Space>" & vbCrLf & "Right click on list box after selecting file(s)." _
                  )

Call CreateToolTip(nHdnlToolTip(4), Me.hwnd, _
                  Me.LstTables, _
                  "Click 2x on table name to view contents." & vbCrLf & "Press <space> to select/deselect" _
                  )

Call CreateToolTip(nHdnlToolTip(5), Me.hwnd, _
                  Me.Frame1, _
                  "Make selections here to determine" & vbCrLf & _
                  "the format of the output text file. These" & vbCrLf & _
                  "parameters will be written to the SCHEMA.INI" & vbCrLf & _
                  "which will be located in the destination folder")

Call CreateToolTip(nHdnlToolTip(6), Me.hwnd, _
                  Me.cmbExportFormat, _
                  "Select the file type" & vbCrLf & "you want to export TO" _
                  )
 

With cmbSourceFormat    ' These are the formats we can convert FROM
 .Clear
 .AddItem "Access"
 .AddItem "dBASE"
 .AddItem "Excel"
 .AddItem "Paradox"
 .AddItem "Text"
 .AddItem "HTML Import"
 .ListIndex = 0
End With

With cmbExportFormat    ' These are the formats we can convert TO
 .Clear
 .AddItem "dBASE III"
 .AddItem "dBASE IV"
 .AddItem "dBASE 5.0"
 .AddItem "Paradox 3.x"
 .AddItem "Paradox 4.x"
 .AddItem "Paradox 5.x"
 .AddItem "Excel 3.0"
 .AddItem "Excel 4.0"
 .AddItem "Excel 5.0"
 .AddItem "Excel 97"
 .AddItem "Excel 8.0"
 .AddItem "Text"
 .AddItem "Access 2000"
 .AddItem "HTML Export"
 .ListIndex = 0
End With
'--------------------------------------------------------
' We have to use 2 FileListBoxes; FlbSource(0) allows
' selection of only 1 file and FlbSource(1) allows
' the selection of multiple files. The need for 2
' FileListBoxes is necessary because the "MultiSelect"
' property of FileListBoxes can only be set at design time:
'--------------------------------------------------------
nFlbInUse = 0

' overlay FlbSource(1):
FlbSource(1).Top = FlbSource(0).Top: FlbSource(1).Left = FlbSource(0).Left

Call MakeSubs           ' Create several subdirectories in THIS folder

DirSource.Path = App.Path
DirTarget.Path = App.Path
DirSource.Path = DrvSource.Drive
FlbSource(0).Path = DirSource.Path
FlbSource(1).Path = DirSource.Path

'--------------------------------------------------------
' Setup the ComboBoxes in the "Text Export Specifications"
' frame; we use these when "Text" is selected as the export
' format:
'--------------------------------------------------------
With cmbDateTime
 .Clear
 .AddItem "mm/dd/yy"
 .AddItem "dd.mm.yy"
 .AddItem "yyyy-mm-dd"
 .ListIndex = 2
End With
With cmbCharSet
 .Clear
 .AddItem "ANSII"
 .AddItem "OEM"
 .ListIndex = 0
End With
With cmbPosCurrFmt
 .Clear
 .AddItem "$1"
 .AddItem "1$"
 .AddItem "$ 1"
 .AddItem "1 $"
 .AddItem "Use System Default"
 .ListIndex = .ListCount - 1
End With
With cmbNegCurrFmt
 .Clear
 .AddItem "($1)"
 .AddItem "-$1"
 .AddItem "$-1"
 .AddItem "$1-"
 .AddItem "(1$)"
 .AddItem "-1$"
 .AddItem "1-$"
 .AddItem "1$-"
 .AddItem "-1 $"
 .AddItem "-$ 1"
 .AddItem "1 $-"
 .AddItem "$ 1-"
 .AddItem "$ -1"
 .AddItem "1- $"
 .AddItem "($ 1)"
 .AddItem "(1 $)"
 .AddItem "Use System Default"
 .ListIndex = .ListCount - 1
End With
With cmbFieldDelimit
 .Clear
 .AddItem "Tab Delimited"
 .AddItem "CSV File"
 .AddItem "Delimit with '|' "
 .AddItem "Fixed Length"
 .AddItem "HTML"
 .ListIndex = 0
End With

'--------------------------------------------------------
' Deactivate the "Text Export Specifications"
' frame; this is only active when "Text" was
' selected as the export format. Have a look
' at the "cmbExportFormat_Click()" event:
'--------------------------------------------------------
Call FrameActivate(False)
End Sub
Private Sub MakeSubs()
'--------------------------------------------------------
' Create a few subdirectories if they do not exist
'--------------------------------------------------------
Dim fso As FileSystemObject
Dim t As String
Dim sSubDirs As String
Dim aSubDirs() As String
Dim X As Integer
Set fso = New FileSystemObject
t = App.Path & IIf(Right$(App.Path, 1) <> "\", "\", "")
sSubDirs = _
        "Access;dBASE3;dBASE4;dBASE5;Excel3;Excel4;Excel5;Excel97;" & _
        "Excel8;Paradox3x;Paradox4x;Paradox5x;Text;HTML"

aSubDirs = Split(sSubDirs, ";")

With fso
 For X = LBound(aSubDirs) To UBound(aSubDirs)
  If Not .FolderExists(t & aSubDirs(X)) Then .CreateFolder t & aSubDirs(X)
 Next
End With

End Sub

Private Sub cmbExportFormat_Click()
'--------------------------------------------------------
' Activate or deactivate the "Text Export Specifications"
' frame, depending on whether "Text" was selected as
' the Export format:
'--------------------------------------------------------
 If InStr(LCase(cmbExportFormat.Text), "text") Then
    Call FrameActivate(True)
 Else
    Call FrameActivate(False)
 End If
 
End Sub

Private Sub cmbSourceFormat_Click()
'--------------------------------------------------------
' Make a decision which of the File List Boxes
' to use. flbSource(0) does not allow multiple
' selections; flbSource(1) does:
'--------------------------------------------------------
Label1(0).Visible = False
LstTables.Visible = False

If LCase(cmbSourceFormat.Text) Like "*access*" Or _
   LCase(cmbSourceFormat.Text) Like "*excel*" Then
   
   nFlbInUse = 0
   Label1(2).Caption = "Databases: Select 1"

Else
  
   nFlbInUse = 1
   Label1(2).Caption = "Tables: Select 1 or more"

End If

FlbSource(nFlbInUse).ZOrder 0
FlbSource(Abs(nFlbInUse - 1)).ZOrder 1
FlbSource(nFlbInUse).Path = DirSource.Path


'--------------------------------------------------------
' Load the File List Box with files
' having the appropriate extension
'--------------------------------------------------------
With FlbSource(nFlbInUse)
     
    Select Case cmbSourceFormat.ListIndex
     
     Case 0
       .Pattern = "*.mdb"
     Case 1
       .Pattern = "*.dbf"
     Case 2
       .Pattern = "*.xls"
     Case 3
       .Pattern = "*.db"
     Case 4
       .Pattern = "*.txt;*.csv"
     Case 5
       .Pattern = "*.htm;*.html"
    
    End Select
    
    .Refresh

End With


End Sub

Private Sub GatherTables(ByRef sExt As String)
Dim sDriver As String
Dim n As Integer
'--------------------------------------------------------
' Gather and display the list of tables (Access/Excel)
' or files (DBF, DB, TXT) contained in the database AND
' assign the connection string we are going to use to
' the form-wide variable "cConStr"
'--------------------------------------------------------
If nFlbInUse = 0 Then       ' Only 1 file can be selected! (MDB, XLS)
    
    For n = 0 To FlbSource(nFlbInUse).ListCount - 1
     If FlbSource(nFlbInUse).Selected(n) Then Exit For
    Next
    cDataSource = FlbSource(nFlbInUse).Path & _
                 IIf(Right$(FlbSource(nFlbInUse).Path, 1) <> "\", "\", "") & _
                 FlbSource(nFlbInUse).List(n)

Else                        ' Multiple files can be selected!
    
    Dim cFilesSelected As String
    For n = 0 To FlbSource(nFlbInUse).ListCount - 1
     
     If FlbSource(nFlbInUse).Selected(n) Then
      cFilesSelected = cFilesSelected & FlbSource(nFlbInUse).List(n) & ";"
     End If

    Next
    If Len(cFilesSelected) > 0 Then
     cFilesSelected = Left$(cFilesSelected, Len(cFilesSelected) - 1)
    Else
     MsgBox "No files selected!", vbCritical + vbInformation, "Oops!"
     FlbSource(nFlbInUse).SetFocus
     Exit Sub
    End If
    

End If


LstTables.Clear

Select Case cmbSourceFormat.ListIndex
    
    Case 0  ' Access    (MDB)
     cExtendedProps = ""
     sDriver = ""

    Case 1  ' dBASE     (DBF)
     sDriver = "dBase IV"
     cDataSource = cLinkFile
    
    Case 2  ' Excel     (XLS)
     cExtendedProps = "Extended Properties=Excel 8.0;"

    Case 3  ' Paradox   (DB)
     cExtendedProps = "Extended Properties=Paradox 5.x;"
     sDriver = "Paradox 5.x"
     cDataSource = cLinkFile
    
    Case 4  ' Text      (TXT,CSV)
     cExtendedProps = "Extended Properties=Text;"
     sDriver = "Text"
     cDataSource = cLinkFile
    
    Case 5  ' HTML      (HTM, HTML)
     cExtendedProps = "Extended Properties=HTML Import;"
     sDriver = "HTML Import"
     cDataSource = cLinkFile

End Select

If sExt = "*.mdb" Or sExt = "*.xls" Then
     
     If sExt = "*.mdb" Then
     
         cConStr = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                   "Data Source=" & cDataSource & ";" & _
                   "Persist Security Info=False"
     
     
     ElseIf sExt = "*.xls" Then
         cConStr = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                   "Data Source=" & cDataSource & ";" & _
                   "Extended Properties=Excel 8.0;"
     
     End If

Else
    
    Dim cDataPath As String
    cDataPath = FlbSource(nFlbInUse).Path & _
                IIf(Right$(FlbSource(nFlbInUse).Path, 1) <> "\", "\", "")
    
  ' Create an empty MDB file we will use
  ' for storing links to the files:
    Call SetUpEmptyMDB(cLinkFile, True)
    
  ' The "LinkdBaseFile" sub creates the links.
    Call LinkdBaseFile(cDataPath, sDriver, cFilesSelected)
    cConStr = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
              "Data Source=" & cLinkFile & ";" & _
              "Persist Security Info=False"
     
End If

On Error GoTo WhatWentAmiss

Dim oCon As ADODB.Connection
Dim oRst As ADODB.Recordset
Set oCon = New ADODB.Connection


 oCon.ConnectionString = cConStr
 oCon.Open

'--------A small aside comment --------------------------
' Another interesting thing you can do with the
' OpenSchema method: find out who is using a database
' Open the user roster schema rowset
' Set oRst = oCon.OpenSchema(adSchemaProviderSpecific, , JET_SCHEMA_USERROSTER)
' Print the results to the debug window
' Debug.Print oRst.GetString
' Returns the following columns
' COMPUTER_NAME   The name of the workstation as specified using the Network icon in Control Panel.
' LOGIN_NAME      The name of the user used to log on to the database if the database has been secured;
'                 otherwise, the default value will be Admin.
' CONNECTED       True, if there is a corresponding user lock in the .ldb file.
' SUSPECTED_STATE True, if the user has left the database in a suspect state; otherwise, Null.
'--------------------------------------------------------

'--------------------------------------------------------
' This call includes Tables (Access) and Worksheets (Excel) *only*
' Set oRst = oCon.OpenSchema(adSchemaTables, Array(Empty, Empty, Empty, "TABLE"))
'--------------------------------------------------------

'--------------------------------------------------------
' This call will include Tables & Queries (Access) or
'                        Worksheets & Named Ranges (Excel)
'--------------------------------------------------------
 Set oRst = oCon.OpenSchema(adSchemaTables)
 oRst.MoveFirst


 Do Until oRst.EOF
  If sExt = "*.mdb" Or sExt = "*.xls" Then
    If oRst("TABLE_TYPE").Value = "VIEW" Or oRst("TABLE_TYPE").Value = "TABLE" Then
     LstTables.AddItem oRst("TABLE_NAME").Value
    End If
  Else
    If oRst("TABLE_TYPE").Value = "LINK" Then
     LstTables.AddItem oRst("TABLE_NAME").Value
    End If
  End If
  
  oRst.MoveNext
 Loop
oRst.Close
Set oRst = Nothing
oCon.Close
Set oCon = Nothing
 


If LstTables.ListCount > 0 Then
    
    Label1(0).Visible = True
    LstTables.Visible = True
    LstTables.Enabled = True
    LstTables.Selected(0) = True    ' force at  least 1 table to be selected
    cmdExport.Enabled = True

Else

    Label1(0).Visible = False
    LstTables.Visible = False
    cmdExport.Enabled = False
    
End If
Exit Sub

WhatWentAmiss:
 MsgBox Err.Number & " occurred: " & Err.Description, vbCritical + vbOKOnly


End Sub
'''''''''''''''''''''''''''''''''''
' This is where the Export occurs!
'''''''''''''''''''''''''''''''''''
Private Sub cmdExport_Click()

If LCase(DirSource.Path) = LCase(DirTarget.Path) Then
 MsgBox "Please select a different" & vbCrLf & _
        "destination folder/subdirectory!", vbCritical + vbInformation, "Thanks in advance"
 
 Exit Sub
End If

Dim X As Integer, sTbl As String
Dim aTbl() As String

'--------------------------------------------------------
' Generate a string of the selected tables,
' delimited by ";" so we can use split()
' later to generate an array:
'--------------------------------------------------------
For X = 0 To LstTables.ListCount - 1
 
 If LstTables.Selected(X) = True Then
  sTbl = sTbl & "" & LstTables.List(X) & "" & ";"
 End If
 
Next

If Len(sTbl) = 0 Then
 MsgBox "No tables selected!", vbCritical + vbOKOnly, "Ooops!"
 LstTables.SetFocus
 Exit Sub
End If

sTbl = Left(sTbl, Len(sTbl) - 1)    ' trim trailing ";"
aTbl = Split(sTbl, ";")




If TestWire = True Then             ' Test our connection string; if no error, continue:
  cmdExport.Enabled = False
  Screen.MousePointer = vbHourglass
    
    txtSQLStatement.Text = ""       ' This (multi-line) TextBox will show all SQL statements
                                    ' used to export the tables
                                    
    Dim oCon As ADODB.Connection
    Dim sSQL As String, sFieldList As String
    
    Dim bIsSourceText As Boolean
    Dim bIsSourceAccess As Boolean
    Dim bIsSourcedBase As Boolean
    Dim bIsSourceParadox As Boolean
    Dim bIsSourceExcel As Boolean
    Dim bIsSourceHTML As Boolean
    
    Dim bIsTargetText As Boolean
    Dim bIsTargetAccess As Boolean
    Dim bIsTargetdBase As Boolean
    Dim bIsTargetParadox As Boolean
    Dim bIsTargetExcel As Boolean
    Dim bIsTargetHTML As Boolean

  ' Open a connection to the data source:
    Set oCon = New ADODB.Connection
    oCon.ConnectionString = cConStr
    oCon.Open
    '--------------------------------------------------------
    ' Exporting Access to other file formats requires special handling
    ' because of OLE field support. When exporting Access-OLE fields
    ' to Excel, you get a run-time error. When exporting to dBASE, there
    ' is no run-time error but the resulting DBF cannot be opened under
    ' dBASE.
    '--------------------------------------------------------
    
    '--------------------------------------------------------
    ' NOTE!! Excel versions < 5.0 do NOT support
    ' multiple tables or long file names (truncated to 8.3)!!
    ' No dBASE version supports long file names or field names
    ' greater than 10 characters.
    '--------------------------------------------------------
  With cmbSourceFormat
    bIsSourceText = LCase(.Text) Like "*text*"
    bIsSourceAccess = LCase(.Text) Like "*access*"
    bIsSourcedBase = LCase(.Text) Like "*dbase*"
    bIsSourceParadox = LCase(.Text) Like "*paradox*"
    bIsSourceExcel = LCase(.Text) Like "*excel*"
    bIsSourceHTML = LCase(.Text) Like "*html*"
  End With
  
  With cmbExportFormat
    bIsTargetText = LCase(.Text) Like "*text*"
    bIsTargetAccess = LCase(.Text) Like "*access*"
    bIsTargetdBase = LCase(.Text) Like "*dbase*"
    bIsTargetParadox = LCase(.Text) Like "*paradox*"
    bIsTargetExcel = LCase(.Text) Like "*excel*"
    bIsTargetHTML = LCase(.Text) Like "*html*"
  End With
   
  If bIsSourceAccess Then
 
   Dim sAccessFileName As String
   sAccessFileName = FlbSource(0).FileName
   sAccessFileName = Replace(sAccessFileName, ".mdb", "")

  End If
    
  If bIsTargetAccess Then
   '--------------------------------------------------------
   ' generate a unique, empty Access target file name;
   ' the name will be "Target" + YEAR_MONTH_DAY_HOUR_MINUTE_SECOND + ".mdb"
   ' in order to insure that it is unique.
   '--------------------------------------------------------
      Dim sTargetFile As String
         sTargetFile = DirTarget.Path & _
                       IIf(Right$(DirTarget.Path, 1) <> "\", "\", "") & _
                       "Target" & Format(Now, "YYYYMMDDHHNNSS") & ".mdb"
      
      Call SetUpEmptyMDB(sTargetFile, False)
  End If
    
  If bIsTargetExcel = True Then
   Dim nExcelVersion As Byte
   nExcelVersion = Val(Mid$(cmbExportFormat.Text, 7))

      'The cmbExportFormat contains
      'Excel 3.0
      'Excel 4.0
      'Excel 5.0
      'Excel 97
      'Excel 8.0
    
  End If
    
  If bIsTargetText Then
   Dim oSchema As clsSchemaFile
   Set oSchema = New clsSchemaFile
   With oSchema
    ' Write the SCHEMA.INI header information:
     .CharacterSet = cmbCharSet.ListIndex
     .CurrencyDecimalSymbol = txtCurrDecSym.Text
     .CurrencyDigits = txtDecimalsCurrency.Text
     .CurrencyNegativeFormat = cmbNegCurrFmt.ListIndex
     .CurrencyPositiveFormat = cmbPosCurrFmt.ListIndex
     .CurrencySymbol = txtCurrencySymbol.Text
     .CurrencyThousandSymbol = txtCurrThouSep.Text
     .DateTimeFormat = IIf(Len(Trim(cmbDateTime.Text)) > 0, cmbDateTime.Text, "yyyy-mm-dd")
     .DecimalSeparator = txtNonCurrDecSym.Text
     .FileDelimiterType = cmbFieldDelimit.ListIndex
     .IncludeFieldNamesInFirstLine = IIf(chkHeaders.Value = 1, True, False)
     .LeadingZerosForValuesLessThanOne = IIf(chkLeadingZeros.Value = 1, True, False)
     .NumberDigits = txtDecimalsNonCurrency.Text
       
     .SourceDataBase = oCon
     .TextDataBasePath = DirTarget.Path
     
   End With
     
  End If

On Error GoTo TellMeWhyItFailed

For X = LBound(aTbl) To UBound(aTbl)   ' Export each selected table.
                                       ' Tables are listed in the "LstTables"
                                       ' ListBox and originate in one
                                       ' of the following sources:
                                       ' Access        -  Tables and Views
                                       ' Excel         -  Worksheets and Named Ranges
                                       ' interface.tob -  links to any of the other
                                       '                  file formats

 '--------------------------------------------------------
 ' Get the list of "exportable" fields; exclude OLE and GUID fields
 ' if the target is not Access:
 '--------------------------------------------------------
  sFieldList = IIf( _
                    (bIsTargetAccess Or bIsSourceText) Or _
                   ((bIsSourcedBase Or bIsSourceParadox) And (bIsTargetdBase Or bIsTargetParadox)) Or _
                    (bIsSourceExcel And bIsTargetExcel), _
                   "*", _
                  GetExportableFields(oCon, aTbl(X), bIsTargetdBase) _
                 )

 
 sSQL = ""                  ' This is the SQL statement we will use to perform the export

If sFieldList <> "" Then    ' If we have any exportable fields (see above), then continue
 
    If bIsTargetText Then
       
     With oSchema
      .QueryOrTableName = aTbl(X)
       sSQL = .CreateExportSQL
       txtSQLStatement.Refresh
     End With
    
    ElseIf bIsTargetAccess Then
       sSQL = "SELECT " & sFieldList & " " & vbCrLf & _
              "INTO [" & aTbl(X) & "] " & vbCrLf & _
              "IN '" & sTargetFile & "' " & vbCrLf & _
              "FROM " & "[" & aTbl(X) & "]"
    
    ElseIf bIsTargetdBase Or bIsTargetParadox Then
       sTargetFile = GetTableName(aTbl(X))
       
       sSQL = "SELECT " & sFieldList & " " & vbCrLf & _
              "INTO [" & cmbExportFormat.Text & ";" & _
                     "Database=" & DirTarget.Path & "]." & _
                     "[" & _
                     Left$(sTargetFile, 8) & _
                     "] " & vbCrLf & _
              "FROM " & "[" & aTbl(X) & "]"
    
    ElseIf bIsTargetExcel Then
     
     If nExcelVersion >= 5 Then    '<------ Export to single Excel file
    
    '--------------------------------------------------------
    ' If the Excel file does not exist, it will be created;
    ' if it does  exist, the  table will be added to the
    ' existing file
    '--------------------------------------------------------
    
    '--------------------------------------------------------
    ' To extract an unnamed range of cells when Excel is the SOURCE
    ' use the syntax "sheetname$range"; for example [1996 Sales$A1:D12]
    '--------------------------------------------------------
    
      sSQL = "SELECT " & sFieldList & " " & vbCrLf & _
             "INTO [" & cmbExportFormat.Text & ";" & _
                    "Database=" & DirTarget.Path & "\" & sAccessFileName & ".xls]." & _
                    "[" & aTbl(X) & "] " & vbCrLf & _
             "FROM " & "[" & aTbl(X) & "]"
     
     Else                          '<------ Export to multiple Excel files
      sTargetFile = GetTableName(aTbl(X))
      sSQL = "SELECT " & sFieldList & " " & vbCrLf & _
             "INTO [" & cmbExportFormat.Text & ";" & _
                    "Database=" & DirTarget.Path & "\" & sTargetFile & "]." & _
                    "[" & sTargetFile & "] " & vbCrLf & _
             "FROM " & "[" & aTbl(X) & "]"
     End If
    
    ElseIf bIsTargetHTML Then
      sTargetFile = GetTableName(aTbl(X))
      sSQL = "SELECT " & sFieldList & " " & vbCrLf & _
             "INTO [" & cmbExportFormat.Text & ";" & _
                    "Database=" & DirTarget.Path & "]." & _
                    "" & _
                    Left$(sTargetFile, 8) & _
                    ".HTM " & vbCrLf & _
             "FROM " & "[" & aTbl(X) & "]"
    
    Else        ' Target ???
    
    End If
  
    If sSQL <> "" Then
      
      txtSQLStatement.Text = txtSQLStatement.Text & sSQL & vbCrLf & String(20, "_") & vbCrLf
      txtSQLStatement.Refresh
      
      
      '--------------------------------------------------------
      '  DO IT!
      '--------------------------------------------------------
      oCon.Execute sSQL, , adCmdText
    
    End If
    
        
End If  ' If sFieldList <> ""
    
Next    ' Next selected Table

GoTo LeaveThis

Else    ' TestWire returned False

 Exit Sub

End If  'If TestWire was true



TellMeWhyItFailed:
    MsgBox Err.Description, vbOKOnly + vbCritical, "Oops! An error occured"
    GoTo LeaveThis

LeaveThis:
oCon.Close
Set oCon = Nothing
cmdExport.Enabled = True
Screen.MousePointer = vbDefault

End Sub
Private Function TestWire() As Boolean
''''''''''''''''''''''''''''
' Test the connection to
' the data source
''''''''''''''''''''''''''''
Dim oCon As ADODB.Connection
Dim oRst As ADODB.Recordset
On Error GoTo err_TestWire
Set oCon = New ADODB.Connection

'--------------------------------------------------------
' Use the form-wide connection string "cConStr";
' this was established in the "GatherTables" sub:
'--------------------------------------------------------
oCon.ConnectionString = cConStr



oCon.Open
oCon.Close
Set oCon = Nothing
TestWire = True
Exit Function

err_TestWire:
MsgBox "Error #:" & Err.Number & vbCrLf & Err.Description, vbCritical + vbOKOnly
TestWire = False
End Function
Private Function GetExportableFields(ByRef oCon As ADODB.Connection, _
                                     ByRef cTable As String, _
                                     ByRef bIsTargetdBase) As String
Dim oRstColumns As ADODB.Recordset
Dim nCol As Integer, nCols As Integer, nPtr As Integer
Dim bSelectColumn As Boolean
Dim sSQL As String
Dim fldName As String
Dim bNameChg As Boolean
bNameChg = False

If bIsTargetdBase Then
 Dim sShortFldName As String
 sShortFldName = "\"
End If

Set oRstColumns = oCon.OpenSchema(adSchemaColumns, Array(Empty, Empty, cTable))
oRstColumns.MoveFirst

'--------------------------------------------------------
' oRstColumns.RecordCount returns -1;
' we have to get the total number of
' columns another way:
'--------------------------------------------------------

nCols = 0
Do Until oRstColumns.EOF
 nCols = nCols + 1
 oRstColumns.MoveNext
Loop

sSQL = ""

oRstColumns.MoveFirst

'--------------------------------------------------------
' Note what the dBASE driver will do: destination
' field names will be truncated to a maximum of 10 characters
' SELECT FieldLongerThan10Characters, FieldLongerThan20Characters
' will try to create 2 dBASE fields called "FieldLonge" and
' an error will occur
'--------------------------------------------------------

For nPtr = 0 To nCols - 1
    bSelectColumn = False
    oRstColumns.MoveFirst
    '--------------------------------------------------------
    ' Let's ensure the natural field order; i.e.
    ' the order in which the fields were originally
    ' created. By default, OpenSchema(adSchemaColumns)
    ' returns columns sorted by NAME
    '--------------------------------------------------------
    oRstColumns.Find "ORDINAL_POSITION=" & CLng(nPtr + 1), , adSearchForward

    Select Case oRstColumns("DATA_TYPE").Value
                
                Case adBoolean                         ' Yes/No field
                   bSelectColumn = True
                Case adUnsignedTinyInt                 ' Byte
                   bSelectColumn = True
                Case adSmallInt                        ' Integer
                   bSelectColumn = True
                Case adInteger                         ' AutoNumber/Long Integer
                   bSelectColumn = True
                Case adCurrency                        ' Currency
                   bSelectColumn = True
                Case adSingle, adNumeric               ' Single/Decimal
                   bSelectColumn = True
                Case adDouble
                   bSelectColumn = True
                Case adDate
                   bSelectColumn = True
                Case adVarWChar                        ' Lookup/Text
                   bSelectColumn = True
                Case adLongVarBinary                   ' OLE
                   bSelectColumn = False
                Case adLongVarWChar                    ' Memo
                   bSelectColumn = True
                Case adGUID                            ' Replication ID
                   bSelectColumn = False               ' dBASE cannot handle this field type
                Case adWChar
                   bSelectColumn = True
    End Select
    
    If bSelectColumn = True Then
      bNameChg = False
      fldName = oRstColumns("COLUMN_NAME").Value
      If InStr(fldName, ".") <> 0 Or _
        InStr(fldName, "#") <> 0 Or _
        InStr(fldName, " ") <> 0 Then
        fldName = Replace(fldName, ".", "")
        fldName = Replace(fldName, " ", "_")
        fldName = Replace(fldName, "#", "")
        bNameChg = True
      End If
      
      If bIsTargetdBase Then
       
       '--------------------------------------------------------
       ' Handle the 10 character field name limitation in
       ' dBASE files.
       ' We could have used an array here but the business of
       ' Redimming and looping through the array to determine
       ' whether the dBASE field name is in use seemed too
       ' tedious; instead, we create a string like
       ' "\Customer\Address\City\" and search that string
       ' By separating each entry with "\" characters,
       ' false matches are avoided; for example, if the
       ' sShortFldName contained "Address" and we searched for
       ' "Ad" there would be a match; instead, we load the
       ' sShortFldName with "\Address\" and seach for "\Ad\"
       ' in which case NO matching string will be found.
       '--------------------------------------------------------
        If InStr(sShortFldName, "\" & Trim(Left$(fldName, 10) & "\")) = 0 Then
         sShortFldName = sShortFldName & Trim(Left$(fldName, 10)) & "\"
        Else
         fldName = Trim(Left$(fldName, 6)) & Format(Now, "NNSS")
         sShortFldName = sShortFldName & fldName & "\"
         bNameChg = True
        End If
      End If
     
     

     sSQL = sSQL & "[" & oRstColumns("COLUMN_NAME").Value & "]"

     If bNameChg = True Then
        sSQL = sSQL & " AS " & fldName
     End If
     sSQL = sSQL & ","

    End If


Next
oRstColumns.Close
Set oRstColumns = Nothing
                                    ' clip trailing ","
GetExportableFields = IIf(sSQL <> "", Left(sSQL, Len(sSQL) - 1), "")


End Function


Private Sub DirSource_Change()
 
 FlbSource(nFlbInUse).Path = DirSource.Path
 FlbSource(nFlbInUse).Refresh
 LstTables.Visible = False
 cmdExport.Enabled = False
 Label1(0).Visible = False

End Sub

Private Sub DirSource_Click()
 
 FlbSource(nFlbInUse).Path = DirSource.Path
 FlbSource(nFlbInUse).Refresh
 FlbSource(Abs(0 - nFlbInUse)).Path = DirSource.Path
 FlbSource(Abs(0 - nFlbInUse)).Refresh

End Sub


Private Sub DrvSource_Change()

 Call CensorDrive(DrvSource, DirSource)
 DirSource.Path = DrvSource.Drive
 FlbSource(nFlbInUse).Path = DirSource.Path
 FlbSource(nFlbInUse).Refresh

End Sub

Private Sub DrvTarget_Change()

 Call CensorDrive(DrvTarget, DirTarget)
 DirTarget.Path = DrvTarget.Drive

End Sub

Private Sub CensorDrive(ByRef oDrv As DriveListBox, oDir As DirListBox)
'--------------------------------------------------------
' Prevent certain types of disk drives
' as sources or targets. We could have
' used the "GetDriveType" API for this:
'--------------------------------------------------------
On Error GoTo Failed
Dim fso As FileSystemObject
Dim d As Drive
Dim t As String
Set fso = New FileSystemObject
Set d = fso.GetDrive(oDrv.Drive)


    Select Case d.DriveType
        Case 0: t = "Unknown"
        Case 1: t = "Removable"
'       Case 2: t = "Fixed"
'       Case 3: t = "Network"
        Case 4: t = "CD-ROM"
        Case 5: t = "RAM Disk"
    End Select

 If Len(t) > 0 Then
  
  oDrv.Drive = "C"
  oDir.Path = oDrv.Drive
  oDir.Refresh
 
 Else
  oDir.Path = oDrv.Drive
  oDir.Refresh
 End If
 
 Exit Sub

Failed:
oDrv.Drive = "C"
oDir.Refresh


End Sub

Private Sub FrameActivate(ByRef bOnOff As Boolean)
Dim X As Integer
With Me
If bOnOff = True Then
 .Frame1.Enabled = True
 .cmbDateTime.BackColor = .txtSQLStatement.BackColor
 .cmbCharSet.BackColor = .txtSQLStatement.BackColor
 .cmbNegCurrFmt.BackColor = .txtSQLStatement.BackColor
 .cmbPosCurrFmt.BackColor = .txtSQLStatement.BackColor
 .cmbFieldDelimit.BackColor = .txtSQLStatement.BackColor
 .txtCurrDecSym.BackColor = .txtSQLStatement.BackColor
 .txtCurrencySymbol.BackColor = .txtSQLStatement.BackColor
 .txtDecimalsCurrency.BackColor = .txtSQLStatement.BackColor
 .txtCurrThouSep.BackColor = .txtSQLStatement.BackColor
 .txtDecimalsNonCurrency.BackColor = .txtSQLStatement.BackColor
 .txtNonCurrDecSym.BackColor = .txtSQLStatement.BackColor
 .chkHeaders.Enabled = True
 .chkLeadingZeros.Enabled = True
 For X = 0 To .Label2.UBound    ' - 1
  .Label2(X).Enabled = True
 Next
Else
 .Frame1.Enabled = False
 .cmbDateTime.BackColor = .BackColor
 .cmbCharSet.BackColor = .BackColor
 .cmbNegCurrFmt.BackColor = .BackColor
 .cmbPosCurrFmt.BackColor = .BackColor
 .cmbFieldDelimit.BackColor = .BackColor
 .txtCurrDecSym.BackColor = .BackColor
 .txtCurrencySymbol.BackColor = .BackColor
 .txtDecimalsCurrency.BackColor = .BackColor
 .txtCurrThouSep.BackColor = .BackColor
 .txtDecimalsNonCurrency.BackColor = .BackColor
 .txtNonCurrDecSym.BackColor = .BackColor
 .chkHeaders.Enabled = False
 .chkLeadingZeros.Enabled = False
 
 For X = 0 To .Label2.UBound    ' - 1
  .Label2(X).Enabled = False
 Next


End If
End With
End Sub

Private Sub FlbSource_Click(Index As Integer)
'--------------------------------------------------------
' If we are displaying a list of Access
' or Excel files, then open the file
' and show the Tables/Worksheets
'--------------------------------------------------------
 If nFlbInUse = 0 Then
  Call GatherTables(FlbSource(nFlbInUse).Pattern)
 End If
End Sub
Private Sub FlbSource_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
 If nFlbInUse = 1 And Button = 2 And Shift = 0 Then ' right-click was performed
  
  Call GatherTables(FlbSource(nFlbInUse).Pattern)
 
 End If
 
End Sub


Private Sub LstTables_DblClick()
'--------------------------------------------------------
' View the contents of a file selected in the
' LstTables ListBox
'--------------------------------------------------------
Dim oRst As ADODB.Recordset
Dim sSQL As String
On Error GoTo TellMeWhatWentWrong
sSQL = "SELECT * FROM [" & LstTables.Text & "]"
  Screen.MousePointer = vbHourglass
  Set oRst = New ADODB.Recordset
  With oRst
   .ActiveConnection = cConStr
   .CursorLocation = adUseClient
   .CursorType = adOpenKeyset
   .Open sSQL, , , adLockReadOnly, adCmdText
  End With

Dim frm As frmBrowser
Set frm = New frmBrowser
frm.SourceRecordSet = oRst
frm.Caption = "Viewing: " & LstTables.Text
Screen.MousePointer = vbDefault
frm.Show vbModal
Exit Sub

TellMeWhatWentWrong:
    MsgBox Err.Description, vbOKOnly + vbCritical, "Oops! An error occured"
    

Screen.MousePointer = vbDefault
End Sub


Private Sub oAbout_Click()
frmAbout.Show vbModal, Me
End Sub

Private Sub oExit_Click()
Unload Me
End Sub

Private Sub txtCurrDecSym_gotfocus()
With txtCurrDecSym
 .SelStart = 0
 .SelLength = Len(.Text)
End With
End Sub
Private Sub txtCurrDecSym_LostFocus()
With txtCurrDecSym
If InStr(".,", .Text) = 0 Then
 .Text = "."
 .SetFocus
End If
End With
End Sub


Private Sub txtNonCurrDecSym_gotfocus()
With txtNonCurrDecSym
 .SelStart = 0
 .SelLength = Len(.Text)
End With
End Sub
Private Sub txtNonCurrDecSym_LostFocus()
With txtNonCurrDecSym
If InStr(".,", .Text) = 0 Then
 .Text = "."
 .SetFocus
End If
End With
End Sub
Private Sub txtCurrencySymbol_GotFocus()
With txtCurrencySymbol
 .SelStart = 0
 .SelLength = Len(.Text)
End With
End Sub

Private Sub txtCurrThouSep_GotFocus()
With txtCurrThouSep
 .SelStart = 0
 .SelLength = Len(.Text)
End With
End Sub
Private Sub txtCurrThouSep_LostFocus()
With txtCurrThouSep
If InStr(".,' ", .Text) = 0 Then
 .Text = ","
 .SetFocus
End If
End With
End Sub
Private Sub txtDecimalsCurrency_GotFocus()
With txtDecimalsCurrency
 .SelStart = 0
 .SelLength = Len(.Text)
End With

End Sub
Private Sub txtDecimalsCurrency_LostFocus()
With txtDecimalsCurrency
If Not IsNumeric(.Text) Then
 .Text = 2
 .SetFocus
ElseIf Val(.Text) < 0 Or Val(.Text) > 4 Then
 .Text = 2
 .SetFocus
End If
End With
End Sub
Private Sub txtDecimalsNonCurrency_GotFocus()
With txtDecimalsNonCurrency
 .SelStart = 0
 .SelLength = Len(.Text)
End With

End Sub

Private Sub txtDecimalsNonCurrency_LostFocus()
With txtDecimalsNonCurrency
If Not IsNumeric(.Text) Then
  .Text = 2
  .SetFocus
End If
End With
End Sub

Private Sub SetUpEmptyMDB(cAccessFile As String, Optional bRepair As Boolean = False)
Dim oCat As ADOX.Catalog
Dim bFileNotExists As Boolean
    
bFileNotExists = (Dir(cAccessFile) = "")

Set oCat = New ADOX.Catalog

If bFileNotExists Then
    
    oCat.Create "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                "Data Source=" & cAccessFile

ElseIf bFileNotExists = False And bRepair = True Then
 
     Dim oCon As ADODB.Connection
     Dim sTables As String
     Dim aTables() As String
     Dim n As Integer
     Set oCon = New ADODB.Connection
     oCon.ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                             "Data Source=" & cAccessFile & ";" & _
                             "Persist Security Info=False"
     oCon.Open
     Set oCat.ActiveConnection = oCon
     Dim oTbl As ADOX.Table
     For Each oTbl In oCat.Tables
    
      If oTbl.Type = "LINK" Then
         sTables = sTables & oTbl.Name & ";"
      End If
     Next
     If sTables <> "" Then
        sTables = Left$(sTables, Len(sTables) - 1)
        aTables = Split(sTables, ";")
        For n = LBound(aTables) To UBound(aTables)
         oCat.Tables.Delete aTables(n)
        Next
        
     End If
     
     oCon.Close
     Set oCon = Nothing
     Set oTbl = Nothing
     Call RepairAndCompact(cAccessFile)

End If

Set oCat = Nothing

End Sub
Private Sub RepairAndCompact(cQualifiedFileName As String)
Dim JRO As JRO.JetEngine    ' Requires "Microsoft Jet and Replication Objects 2.X Library"
Dim tmpDbFile As String

    'Assign a temp and backup database
    tmpDbFile = GetWinTempPath & "~~~" & "temp.mdb"
    If (Len(Dir(tmpDbFile)) > 0) Then Kill (tmpDbFile)

    'Compress the database
    Set JRO = New JRO.JetEngine
    JRO.CompactDatabase _
             "Provider=Microsoft.Jet.OLEDB.4.0;" & _
             "Data Source=" & cQualifiedFileName _
             , _
             "Provider=Microsoft.Jet.OLEDB.4.0;" & _
             "Data Source=" & tmpDbFile & ";" & _
             "Jet OLEDB:Engine Type=5"
    
            '--------------------------------------------------------
            '"Jet OLEDB:Engine Type"    A Long value (read/write) that specifies which Jet
            '                           database engine I-ISAM driver to use to access this
            '                           database or file format. When you create a new database
            '                           by using the Create method of the ADOX Catalog object,
            '                           this can be used to specify the format for the new
            '                           database. Once a database has been opened, this property
            '                           can be read to determine what file version or format is
            '                           open. The Jet OLEDB:Engine Type property can be any of the
            '                           following Values:
            '
            'Engine Type      Value
            'Unknown             0
            'Microsoft Jet 1.0   1
            'Microsoft Jet 1.1   2
            'Microsoft Jet 2.0   3
            'Microsoft Jet 3.x   4
            'Microsoft Jet 4.x   5
            'dBASE III          10
            'dBASE 4            11
            'dBASE 5            12
            'Excel 3.0          20
            'Excel 4.0          21
            'Excel 5.0          22
            'Excel 8.0          23
            'Excel 9.0          24
            'Exchange 4         30
            'Lotus WK1          40
            'Lotus WK3          41
            'Lotus WK4          42
            'Paradox 3.x        50
            'Paradox 4.x        51
            'Paradox 5.x        52
            'Paradox 7.x        53
            'Text 1.x           60
            'Html 1.x           70
            '--------------------------------------------------------
            
    Set JRO = Nothing
    Kill cQualifiedFileName
    Name tmpDbFile As cQualifiedFileName

End Sub
Private Function GetWinTempPath() As String
Dim sTempPath As String
    On Error GoTo errTempPath

    sTempPath = String(100, Chr$(0))
    'Get the temporary path
    GetTempPath 100, sTempPath
    'strip the rest of the buffer
    sTempPath = Left$(sTempPath, InStr(sTempPath, Chr$(0)) - 1)

    If (Len(Dir(sTempPath, vbDirectory)) > 0) Then
        GetWinTempPath = sTempPath
    Else
        GetWinTempPath = App.Path & "\"
    End If

    Exit Function

errTempPath:
    GetWinTempPath = App.Path & "\"
End Function
Private Function LinkdBaseFile(ByVal strPath As String, _
                               ByVal strLinkPro As String, _
                               ByVal sFileStr As String)

'--------------------------------------------------------
' Sample call:
' Call LinkdBaseFile("c:\MyDbaseFiles\", _
'                    "Dbase IV", _
'                    "Customer;Orders;Invoices" _
'                    )
'--------------------------------------------------------

On Error GoTo TellMeWhatWentWrong

Dim nx As Integer
Dim cFileStr() As String
    cFileStr = Split(sFileStr, ";")
    
Dim oCon As ADODB.Connection
Dim oCat As ADOX.Catalog
Dim oTbl As ADOX.Table
Set oCon = New ADODB.Connection

'--------------------------------------------------------
' Connect to the Access interface where links are stored:
'--------------------------------------------------------
oCon.ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                        "Data Source=" & cLinkFile & ";" & _
                        "Persist Security Info=False;"
oCon.Open

' Open the Catalog
Set oCat = New ADOX.Catalog
Set oCat.ActiveConnection = oCon

For nx = LBound(cFileStr) To UBound(cFileStr)

         If LCase(cmbSourceFormat.Text) Like "*html*" Then
            
            '--------------------------------------------------------
            ' HTML documents *may* contain multiple tables,  <TABLE>...</TABLE><TABLE>...</TABLE>
            ' and therefore resemble Access databases (1 file/multiple tables). The table names
            ' are derived as follows:
            ' 1. If the "<CAPTION>" tag is present, it defines the table name.
            ' 2. If the table (a) does not have any "<CAPTION>" tags, and (b) it is the only
            '    table in the file, use the <TITLE> of the HTML file to refer to the table.
            ' 3. If (a) more than one table exists and (b) none of the tables has a caption,
            '    and (c) there is NO <TITLE></TITLE> tag you refer to them sequentially as
            '    Table, Table1, Table2 and so on.
            ' 4. If (a) more than one table exists and (b) none of the tables has a caption,
            '    and (c) there IS a <TITLE>SomeName</TITLE> tag you refer to them sequentially as
            '    SomeName, SomeName1, SomeName2 and so on.
            '
            ' Basically, this is all academic because we will use the "OpenSchema" method of
            ' the Connection object to get the Table names for us (if the HTML document, in
            ' fact contains any tables)
            ' See: http://msdn.microsoft.com/library/default.asp?url=/library/en-us/odeopg/html/deovrcreatinglinkedtable.asp
            '--------------------------------------------------------
            
             Call GatherHTMLTables(strPath & cFileStr(nx), oCat, cFileStr(nx))
         
         Else   ' any source file other than HTML format
            
            Set oTbl = New ADOX.Table
            With oTbl
                .Name = Replace(cFileStr(nx), ".", "_")
            Set .ParentCatalog = oCat
                .Properties.Refresh
               ' Set the properties to create the link.
                .Properties("Jet OLEDB:Create Link") = True
                .Properties("Jet OLEDB:Cache Link Name/Password") = False
                .Properties("Jet OLEDB:Exclusive Link") = False
                .Properties("Jet OLEDB:Table Hidden In Access") = False
                .Properties("Jet OLEDB:Link Provider String") = strLinkPro
                .Properties("Jet OLEDB:Link Datasource") = strPath
                .Properties("Jet OLEDB:Remote Table Name") = cFileStr(nx)
            End With
          
          ' Append the table to the tables collection of the oCatalog.
            oCat.Tables.Append oTbl
            oCat.Tables.Refresh
         
         
         End If
  
Next


GoTo OuttaHere


TellMeWhatWentWrong:
 MsgBox "Error Number: " & Err.Number & " " & Err.Description
 GoTo OuttaHere

OuttaHere:
Set oCat = Nothing
oCon.Close
Set oCon = Nothing

End Function
Private Sub GatherHTMLTables(cDataBase As String, oCat As ADOX.Catalog, cFileName As String)
Dim oCon As ADODB.Connection
Dim oRst As ADODB.Recordset
Dim oTbl As ADOX.Table

Dim n As Integer
Set oCon = New ADODB.Connection
         
'--------------------------------------------------------
' NOTE that for HTML files, analogous to Access
' databases, the "Data Source" is the fully qualified
' file name; thus, the "cDataBase" parameter would
' contain something like "c:\MyHTMLDocs\SomeFile.htm"
'--------------------------------------------------------
oCon.ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                        "Data Source=" & cDataBase & ";" & _
                        "Extended Properties=HTML Import;"
     
oCon.Open

'--------------------------------------------------------
' We can use the "OpenSchema" method on HTML "Databases"
' just like Access and Excel files; the tables in an
' HTML "Database" are recognizable by the <TABLE>..</TABLE>
' tags.
'--------------------------------------------------------
Set oRst = oCon.OpenSchema(adSchemaTables)
With oRst

    If Not .BOF And Not .EOF Then
        .MoveFirst
        Do Until .EOF
         
         If oRst("TABLE_TYPE").Value = "TABLE" Then
         
            Set oTbl = New ADOX.Table
            With oTbl
                
                .Name = Replace(cFileName, ".", "") & "_" & oRst("TABLE_NAME").Value
                 n = n + 1
            Set .ParentCatalog = oCat
                .Properties.Refresh
               
               ' Set the properties to create the link.
                .Properties("Jet OLEDB:Create Link") = True
                .Properties("Jet OLEDB:Link Provider String") = _
                       "HTML Import;DATABASE=" & cDataBase & ";HDR=YES"
                .Properties("Jet OLEDB:Remote Table Name") = oRst("TABLE_NAME").Value
'                .Properties("Jet OLEDB:Cache Link Name/Password") = False
'                .Properties("Jet OLEDB:Exclusive Link") = False
'                .Properties("Jet OLEDB:Table Hidden In Access") = False
'                .Properties("Jet OLEDB:Link Provider String") = strLinkPro
'                .Properties("Jet OLEDB:Link Datasource") = strPath
'                .Properties("Jet OLEDB:Remote Table Name") = cFileStr(nx)
            
            End With
          
          ' Append the table to the tables collection of the oCatalog.
            oCat.Tables.Append oTbl
            oCat.Tables.Refresh

         End If
         
        .MoveNext
        
        Loop
    End If

End With

oRst.Close
oCon.Close
Set oRst = Nothing
Set oCon = Nothing

End Sub

Private Function RefreshLinkedDBase(strPath As String, _
                                    oCon As ADODB.Connection)

'--------------------------------------------------------
' We don't used this function but it could be used
' if the location of the linked files changes
'--------------------------------------------------------
Dim oCat As ADOX.Catalog
Dim oTbl As ADOX.Table
Set oCat = New ADOX.Catalog
' Open the catalog.
oCat.ActiveConnection = oCon

'Cycle through all tables.
For Each oTbl In oCat.Tables
' Check to make sure each table is a linked table.
    If oTbl.Type = "LINK" Then

        'Set the path apporpriately
        oTbl.Properties("Jet OLEDB:Link Datasource") = strPath
    
    End If
Next
End Function

