VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSchemaFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

Option Explicit
Private m_cDateTimeFormat As String
Private m_nCharacterSet As CharacterSet2Use
Private m_cCurrencySymbol As String
Private m_nCurrencyDigits As Integer
Private m_nCurrencyPositiveFormat As PositiveCurrencyFormat
Private m_nCurrencyNegativeFormat As NegativeCurrencyFormat
Private m_cCurrencyDecimalSymbol As String
Private m_cCurrencyThousandSymbol As String
Private m_nNumberDigits As Integer
Private m_cDecimalSeparator As String
Private m_bLeadingZeros As Boolean
Private m_nDelimiterType As DelimiterType
Private m_bIncludeFieldNames As Boolean



Private m_cTextDataBasePath As String

Private m_oSourceDataBase As ADODB.Connection
Private m_cTableOrQueryName As String

'//---- Public enumerators    --------- //
Public Enum CharacterSet2Use
  ANSII = 0
  OEM = 1
End Enum

Public Enum NegativeCurrencyFormat
  Parentheses_DM101 = 0
  MinusDM101 = 1
  DMMinus102 = 2
  DM103Minus = 3
  Parentheses_104DM = 4
  Minusl05DM = 5
  l06MinusDM = 6
  l07DMMinus = 7
  Minusl08_DM = 8
  MinusDM_109 = 9
  l10_DMMinus = 10
  DM_111Minus = 11
  DM_Minus112 = 12
  l13Minus_DM = 13
  ParenthesesDM_114 = 14
  Parentheses115_DM = 15
  UseNegCurrSystemDefault = 16
End Enum

Public Enum PositiveCurrencyFormat
  DM100 = 0
  l00DM = 1
  DM_100 = 2
  l00_DM = 3
  UseSystemCurrDefault = 4
End Enum

Public Enum DelimiterType
 dtTabDelimited = 0
 dtCSVDelimited = 1
 dtPipeDelimited = 2
 dtFixedLength = 3
 dtHTML = 4
End Enum

'//---- Private enumerators   --------- //
Private Enum LocaleInfo
    LOCALE_ICENTURY = &H24                '  century format specifier
    LOCALE_ICOUNTRY = &H5                 '  country code
    LOCALE_ICURRDIGITS = &H19             '  # local monetary digits
    LOCALE_ICURRENCY = &H1B               '  positive currency mode
    LOCALE_IDATE = &H21                   '  short date format ordering
    LOCALE_IDAYLZERO = &H26               '  leading zeros in day field
    LOCALE_IDEFAULTCODEPAGE = &HB         '  default code page
    LOCALE_IDEFAULTCOUNTRY = &HA          '  default country code
    LOCALE_IDEFAULTLANGUAGE = &H9         '  default language id
    LOCALE_IDIGITS = &H11                 '  number of fractional digits
    LOCALE_IINTLCURRDIGITS = &H1A         '  # intl monetary digits
    LOCALE_ILANGUAGE = &H1                '  language id
    LOCALE_ILDATE = &H22                  '  long date format ordering
    LOCALE_ILZERO = &H12                  '  leading zeros for decimal
    LOCALE_IMEASURE = &HD                 '  0 = metric, 1 = US
    LOCALE_IMONLZERO = &H27               '  leading zeros in month field
    LOCALE_INEGCURR = &H1C                '  negative currency mode
    LOCALE_INEGSEPBYSPACE = &H57          '  mon sym sep by space from neg amt
    LOCALE_INEGSIGNPOSN = &H53            '  negative sign position
    LOCALE_INEGSYMPRECEDES = &H56         '  mon sym precedes neg amt
    LOCALE_IPOSSEPBYSPACE = &H55          '  mon sym sep by space from pos amt
    LOCALE_IPOSSIGNPOSN = &H52            '  positive sign position
    LOCALE_IPOSSYMPRECEDES = &H54         '  mon sym precedes pos amt
    LOCALE_ITIME = &H23                   '  time format specifier
    LOCALE_ITLZERO = &H25                 '  leading zeros in time field
    LOCALE_NOUSEROVERRIDE = &H80000000    '  do not use user overrides
    LOCALE_S1159 = &H28                   '  AM designator
    LOCALE_S2359 = &H29                   '  PM designator
    LOCALE_SABBREVCTRYNAME = &H7          '  abbreviated country name
    LOCALE_SABBREVDAYNAME1 = &H31         '  abbreviated name for Monday
    LOCALE_SABBREVDAYNAME2 = &H32         '  abbreviated name for Tuesday
    LOCALE_SABBREVDAYNAME3 = &H33         '  abbreviated name for Wednesday
    LOCALE_SABBREVDAYNAME4 = &H34         '  abbreviated name for Thursday
    LOCALE_SABBREVDAYNAME5 = &H35         '  abbreviated name for Friday
    LOCALE_SABBREVDAYNAME6 = &H36         '  abbreviated name for Saturday
    LOCALE_SABBREVDAYNAME7 = &H37         '  abbreviated name for Sunday
    LOCALE_SABBREVLANGNAME = &H3          '  abbreviated language name
    LOCALE_SABBREVMONTHNAME1 = &H44       '  abbreviated name for January
    LOCALE_SABBREVMONTHNAME10 = &H4D      '  abbreviated name for October
    LOCALE_SABBREVMONTHNAME11 = &H4E      '  abbreviated name for November
    LOCALE_SABBREVMONTHNAME12 = &H4F      '  abbreviated name for December
    LOCALE_SABBREVMONTHNAME13 = &H100F
    LOCALE_SABBREVMONTHNAME2 = &H45       '  abbreviated name for February
    LOCALE_SABBREVMONTHNAME3 = &H46       '  abbreviated name for March
    LOCALE_SABBREVMONTHNAME4 = &H47       '  abbreviated name for April
    LOCALE_SABBREVMONTHNAME5 = &H48       '  abbreviated name for May
    LOCALE_SABBREVMONTHNAME6 = &H49       '  abbreviated name for June
    LOCALE_SABBREVMONTHNAME7 = &H4A       '  abbreviated name for July
    LOCALE_SABBREVMONTHNAME8 = &H4B       '  abbreviated name for August
    LOCALE_SABBREVMONTHNAME9 = &H4C       '  abbreviated name for September
    LOCALE_SCOUNTRY = &H6                 '  localized name of country
    LOCALE_SCURRENCY = &H14               '  local monetary symbol
    LOCALE_SDATE = &H1D                   '  date separator
    LOCALE_SDAYNAME1 = &H2A               '  long name for Monday
    LOCALE_SDAYNAME2 = &H2B               '  long name for Tuesday
    LOCALE_SDAYNAME3 = &H2C               '  long name for Wednesday
    LOCALE_SDAYNAME4 = &H2D               '  long name for Thursday
    LOCALE_SDAYNAME5 = &H2E               '  long name for Friday
    LOCALE_SDAYNAME6 = &H2F               '  long name for Saturday
    LOCALE_SDAYNAME7 = &H30               '  long name for Sunday
    LOCALE_SDECIMAL = &HE                 '  decimal separator
    LOCALE_SENGCOUNTRY = &H1002           '  English name of country
    LOCALE_SENGLANGUAGE = &H1001          '  English name of language
    LOCALE_SGROUPING = &H10               '  digit grouping
    LOCALE_SINTLSYMBOL = &H15             '  intl monetary symbol
    LOCALE_SLANGUAGE = &H2                '  localized name of language
    LOCALE_SLIST = &HC                    '  list item separator
    LOCALE_SLONGDATE = &H20               '  long date format string
    LOCALE_SMONDECIMALSEP = &H16          '  monetary decimal separator
    LOCALE_SMONGROUPING = &H18            '  monetary grouping
    LOCALE_SMONTHNAME1 = &H38             '  long name for January
    LOCALE_SMONTHNAME10 = &H41            '  long name for October
    LOCALE_SMONTHNAME11 = &H42            '  long name for November
    LOCALE_SMONTHNAME12 = &H43            '  long name for December
    LOCALE_SMONTHNAME2 = &H39             '  long name for February
    LOCALE_SMONTHNAME3 = &H3A             '  long name for March
    LOCALE_SMONTHNAME4 = &H3B             '  long name for April
    LOCALE_SMONTHNAME5 = &H3C             '  long name for May
    LOCALE_SMONTHNAME6 = &H3D             '  long name for June
    LOCALE_SMONTHNAME7 = &H3E             '  long name for July
    LOCALE_SMONTHNAME8 = &H3F             '  long name for August
    LOCALE_SMONTHNAME9 = &H40             '  long name for September
    LOCALE_SMONTHOUSANDSEP = &H17         '  monetary thousand separator
    LOCALE_SNATIVECTRYNAME = &H8          '  native name of country
    LOCALE_SNATIVEDIGITS = &H13           '  native ascii 0-9
    LOCALE_SNATIVELANGNAME = &H4          '  native name of language
    LOCALE_SNEGATIVESIGN = &H51           '  negative sign
    LOCALE_SPOSITIVESIGN = &H50           '  positive sign
    LOCALE_SSHORTDATE = &H1F              '  short date format string
    LOCALE_STHOUSAND = &HF                '  thousand separator
    LOCALE_STIME = &H1E                   '  time separator
    LOCALE_STIMEFORMAT = &H1003           '  time format string
End Enum

Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" _
                                                             (ByVal Locale As Long, _
                                                              ByVal LCType As Long, _
                                                              ByVal lpLCData As String, _
                                                              ByVal cchData As Long) As Long
Private Declare Function SetLocaleInfo Lib "kernel32" Alias "SetLocaleInfoA" _
                                                             (ByVal Locale As Long, _
                                                              ByVal LCType As Long, _
                                                              ByVal lpLCData As String) _
                                                              As Long
Private Declare Function GetUserDefaultLCID Lib "kernel32" () As Long
Private Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long

' Return a piece of locale information.
Private Function LocaleInfo(ByVal Locale As Long, ByVal lc_type As Long) As String
Dim length As Long
Dim buf As String * 1024


    length = GetLocaleInfo(Locale, lc_type, buf, Len(buf))
    LocaleInfo = Left$(buf, length - 1)
End Function
Private Function GetLocalSetting(cInfo As LocaleInfo)
Dim locale_id As Long

    locale_id = GetUserDefaultLCID()
    GetLocalSetting = LocaleInfo(locale_id, cInfo)
    

End Function

' Just for the record...We won't mess with
' the local settings, but if we wanted to
' we'd use this function:
Private Function SetLocalSetting(cInfo As LocaleInfo, cValue As String) As Long
Dim llngLCID As Long
Dim llngReturn As Long


    llngLCID = GetSystemDefaultLCID
    llngReturn = SetLocaleInfo(llngLCID, cInfo, cValue)
    SetLocalSetting = llngReturn

End Function


Private Sub Class_Initialize()

    m_cDateTimeFormat = GetLocalSetting(LOCALE_SSHORTDATE)
    m_cCurrencySymbol = GetLocalSetting(LOCALE_SCURRENCY)
    m_nCurrencyDigits = CInt(GetLocalSetting(LOCALE_ICURRDIGITS))
    m_cDecimalSeparator = GetLocalSetting(LOCALE_SMONDECIMALSEP)
    m_nCurrencyPositiveFormat = CInt(GetLocalSetting(LOCALE_ICURRENCY))
    m_nCurrencyNegativeFormat = CInt(GetLocalSetting(LOCALE_INEGCURR))
    m_cCurrencyDecimalSymbol = GetLocalSetting(LOCALE_SMONDECIMALSEP)
    m_cCurrencyThousandSymbol = GetLocalSetting(LOCALE_SMONTHOUSANDSEP)
    m_nNumberDigits = CInt(GetLocalSetting(LOCALE_IDIGITS))
    m_cTextDataBasePath = App.Path
    m_bIncludeFieldNames = True
    m_bLeadingZeros = True
    m_nCharacterSet = ANSII
    m_nDelimiterType = dtCSVDelimited
    
End Sub

Public Property Get DateTimeFormat() As String
 DateTimeFormat = m_cDateTimeFormat
End Property

Public Property Let DateTimeFormat(ByVal cNewValue As String)
 m_cDateTimeFormat = cNewValue
End Property

Public Property Get CurrencySymbol() As String
 CurrencySymbol = m_cCurrencySymbol
End Property

Public Property Let CurrencySymbol(ByVal cNewValue As String)
 m_cCurrencySymbol = cNewValue
End Property

Public Property Get CurrencyDigits() As Integer
CurrencyDigits = m_nCurrencyDigits
End Property

Public Property Let CurrencyDigits(ByVal nNewValue As Integer)
 m_nCurrencyDigits = nNewValue
End Property

Public Property Get DecimalSeparator() As String
 DecimalSeparator = m_cDecimalSeparator
End Property

Public Property Let DecimalSeparator(ByVal cNewValue As String)
 m_cDecimalSeparator = cNewValue
End Property

Public Property Get CurrencyPositiveFormat() As PositiveCurrencyFormat
 CurrencyPositiveFormat = m_nCurrencyPositiveFormat
End Property

Public Property Let CurrencyPositiveFormat(ByVal nNewValue As PositiveCurrencyFormat)
 If nNewValue = UseSystemCurrDefault Then
  m_nCurrencyPositiveFormat = CInt(GetLocalSetting(LOCALE_ICURRENCY))
 Else
  m_nCurrencyPositiveFormat = nNewValue
 End If
End Property

Public Property Get CurrencyNegativeFormat() As NegativeCurrencyFormat
 CurrencyNegativeFormat = m_nCurrencyNegativeFormat
End Property

Public Property Let CurrencyNegativeFormat(ByVal nNewValue As NegativeCurrencyFormat)
If nNewValue = UseNegCurrSystemDefault Then
 m_nCurrencyNegativeFormat = CInt(GetLocalSetting(LOCALE_INEGCURR))
Else
 m_nCurrencyNegativeFormat = nNewValue
End If
End Property

Public Property Let TextDataBasePath(ByVal cPath As String)
 m_cTextDataBasePath = cPath
End Property

Public Property Get TextDataBasePath() As String
 TextDataBasePath = m_cTextDataBasePath
End Property

Public Property Get CurrencyDecimalSymbol() As String
 CurrencyDecimalSymbol = m_cCurrencyDecimalSymbol
End Property

Public Property Let CurrencyDecimalSymbol(ByVal cNewValue As String)
 m_cCurrencyDecimalSymbol = cNewValue
End Property

Public Property Get CurrencyThousandSymbol() As String
 CurrencyThousandSymbol = m_cCurrencyThousandSymbol
End Property

Public Property Let CurrencyThousandSymbol(ByVal cNewValue As String)
 m_cCurrencyThousandSymbol = cNewValue
End Property

Public Property Get NumberDigits() As Integer
 NumberDigits = m_nNumberDigits
End Property

Public Property Let NumberDigits(ByVal nNewValue As Integer)
 m_nNumberDigits = nNewValue
End Property

Public Property Let IncludeFieldNamesInFirstLine(ByVal bIncludeFieldNames As Boolean)
 m_bIncludeFieldNames = bIncludeFieldNames
End Property

Public Property Get IncludeFieldNamesInFirstLine() As Boolean
 IncludeFieldNamesInFirstLine = m_bIncludeFieldNames
End Property

Public Property Let SourceDataBase(ByVal oSourceDataBase As ADODB.Connection)
 Set m_oSourceDataBase = oSourceDataBase
End Property

Public Property Get SourceDataBase() As ADODB.Connection
 Set SourceDataBase = m_oSourceDataBase
End Property

Public Property Let QueryOrTableName(ByVal cTableOrQueryName As String)
 m_cTableOrQueryName = cTableOrQueryName
End Property

Public Property Get QueryOrTableName() As String
 QueryOrTableName = m_cTableOrQueryName
End Property

Public Property Let LeadingZerosForValuesLessThanOne(ByVal bLeadingZeros As Boolean)
 m_bLeadingZeros = bLeadingZeros
End Property

Public Property Get LeadingZerosForValuesLessThanOne() As Boolean
 LeadingZerosForValuesLessThanOne = m_bLeadingZeros
End Property

Public Property Let CharacterSet(ByVal nCharSet As CharacterSet2Use)
 m_nCharacterSet = nCharSet
End Property

Public Property Get CharacterSet() As CharacterSet2Use
 CharacterSet = m_nCharacterSet
End Property

Public Property Let FileDelimiterType(nDelimiterType As DelimiterType)
 m_nDelimiterType = nDelimiterType
End Property

Public Property Get FileDelimiterType() As DelimiterType
 FileDelimiterType = m_nDelimiterType
End Property
Private Sub WriteHeader()
Dim Handle As Integer
Dim TableName As String
Dim sSchemaFile As String


TableName = GetTableName(QueryOrTableName)
TableName = "[" & TableName & _
             IIf(FileDelimiterType <> dtHTML, ".txt", ".htm") & _
            "]"

sSchemaFile = TextDataBasePath & _
              IIf(Right(TextDataBasePath, 1) <> "\", "\", "") & _
              "schema.ini"

''''''''''''''''''''''''''''''''''''''''''''
' If there is already an entry
' in the schema.ini for this table
' then remove it:
''''''''''''''''''''''''''''''''''''''''''''
If Dir$(sSchemaFile) <> "" Then
 Dim sFileContent As String
 Handle = FreeFile
 Open sSchemaFile For Binary Access Read As #Handle
 sFileContent = Input(LOF(Handle), #Handle)
 Close Handle
 If Len(sFileContent) > 0 Then
' If LOF(Handle) > 0 Then
    Dim nTableTag As Integer
    Dim nFindLeftBracket As Integer
    
 '  sFileContent = Input(LOF(Handle), #Handle)
    nTableTag = InStr(1, sFileContent, TableName)
    nFindLeftBracket = InStr(1, sFileContent, "[")
    
    If nTableTag <> 0 Then
     
         If nTableTag = nFindLeftBracket Then   ' Table specs are at the beginning of the schema.ini
            
            nFindLeftBracket = InStr(nTableTag + 1, sFileContent, "[") ' find next left bracket
            If nFindLeftBracket <> 0 Then       ' Other table specs exist
              sFileContent = Mid$(sFileContent, nFindLeftBracket)
            Else                                ' No other table specs exist in the schema.ini
              sFileContent = ""
              Kill sSchemaFile
            End If
         
         Else                                   ' Table specs are located somewhere other than the
                                                ' beginning of the schema.ini
              
              nFindLeftBracket = InStr(nTableTag + 1, sFileContent, "[") ' find next left bracket
              If nFindLeftBracket = 0 Then      ' Table specs are the last entry in the schema.ini
               sFileContent = Mid$(sFileContent, 1, nTableTag - 1)
              Else                              ' Table specs are located before the end
               sFileContent = Mid$(sFileContent, 1, nTableTag - 1) & _
                              Mid$(sFileContent, nFindLeftBracket)
              End If
        
         End If
     
    
    Else    ' Table specs are not in the schema.ini
    
          sFileContent = ""
    
    End If
 
 
 End If         ' LOF(Handle) > 0
 
 

If sFileContent <> "" Then Kill sSchemaFile

End If          ' Dir$(sSchemaFile) <> ""

Handle = FreeFile
Open sSchemaFile For Append Access Write As #Handle

''''''''''''''''''''''''''''''''''''''''''''
' If we collected table structure information
' from the schema.ini for tables OTHER than
' the one we are working on, then write this
' information back to the schema.ini:
''''''''''''''''''''''''''''''''''''''''''''
If Len(sFileContent) > 0 Then

 If Right$(sFileContent, 2) = vbCrLf Then
    sFileContent = Left$(sFileContent, Len(sFileContent) - 2)
 End If
 If Left$(sFileContent, 2) = vbCrLf Then
    sFileContent = Mid$(sFileContent, 3)
 End If
 
 Print #Handle, sFileContent
 
End If

''''''''''''''''''''''''''''''''''''''''''''
' Now write the header information to the
' schema.ini for this table.
''''''''''''''''''''''''''''''''''''''''''''
 Print #Handle, TableName
 Print #Handle, "ColNameHeader = " & IIf(IncludeFieldNamesInFirstLine, "True", "False")
 Print #Handle, "CharacterSet = " & IIf(CharacterSet = ANSII, "ANSI", "OEM")
 Print #Handle, "DateTimeFormat = " & DateTimeFormat
 Print #Handle, "CurrencySymbol = " & CurrencySymbol
 Print #Handle, "CurrencyDigits = " & CurrencyDigits

 Print #Handle, "CurrencyThousandSymbol = " & CurrencyThousandSymbol
                                             'Indicates the single-character symbol
                                             'to be used for separating currency values
                                             'in the text file by thousands.



 
 Print #Handle, "CurrencyDecimalSymbol = " & CurrencyDecimalSymbol
                                             'Can be set to any single character that
                                             'is used to separate the whole from the
                                             'fractional part of a currency amount.
 
 Print #Handle, "DecimalSymbol = " & DecimalSeparator

 Print #Handle, "NumberDigits = " & NumberDigits
                                             'Indicates the number of decimal digits
                                             'in the fractional portion of a number.
 
 
 Print #Handle, "NumberLeadingZeros = " & IIf(LeadingZerosForValuesLessThanOne, "True", "False")
                                             'Specifies whether a
                                             'decimal value less than 1 and
                                             'greater than -1 should contain
                                             'leading zeros; this value can
                                             'either be False (no leading
                                             'zeros) or True.


'CurrencyPosFormat  Can be set to any of the following values:
'0: Currency symbol prefix with no separation ($1)
'1: Currency symbol suffix with no separation (1$)
'2: Currency symbol prefix with one character separation ($ 1)
'3: Currency symbol suffix with one character separation (1 $)
'If this entry is absent, the default value in the Control Panel is used.
 Print #Handle, "CurrencyPosFormat = " & CurrencyPositiveFormat
 
'CurrencyNegFormat  Can be one of the following values:
' 0: ($1)
' 1: -$1
' 2: $-1
' 3: $1-
' 4: (1$)
' 5: -1$
' 6: 1-$
' 7: 1$-
' 8: -1 $
' 9: -$ 1
'10: 1 $-
'11: $ 1-
'12: $ -1
'13: 1- $
'14: ($ 1)
'15: (1 $)
 Print #Handle, "CurrencyNegFormat = " & CurrencyNegativeFormat
 
 If FileDelimiterType = dtCSVDelimited Then
   Print #Handle, "Format = CSVDelimited"
 ElseIf FileDelimiterType = dtPipeDelimited Then
   Print #Handle, "Format = Delimited(|)"
 ElseIf FileDelimiterType = dtFixedLength Then
   Print #Handle, "Format = FixedLength"
 ElseIf FileDelimiterType = dtTabDelimited Then
   Print #Handle, "Format = TabDelimited"
 ElseIf FileDelimiterType = dtHTML Then
   Print #Handle, "Format = HTML"
 End If

Close Handle

End Sub
Public Function CreateExportSQL() As String

Dim Handle As Integer
Dim oCat As ADOX.Catalog
Dim oRs As ADODB.Recordset
Dim nColumnCount As Integer
Dim cSelect As String
Dim i As Integer
Dim fldName As String
Dim fldDataInfo As String
Dim TableName As String


Call WriteHeader


Set oCat = New ADOX.Catalog
Set oCat.ActiveConnection = SourceDataBase

' -----------------------------------------------
' Open schema file for append.
' -----------------------------------------------
Handle = FreeFile
Open TextDataBasePath & _
            IIf(Right(TextDataBasePath, 1) <> "\", "\", "") & _
            "schema.ini" For Append Access Write As #Handle

 
 ' -----------------------------------------------
 ' Write schema column definitions.
 ' -----------------------------------------------
      ' If the "table" is a dBASE or Paradox file (with extension)
      ' then remove the extension!
        TableName = GetTableName(QueryOrTableName)
        nColumnCount = oCat.Tables(QueryOrTableName).Columns.Count - 1
        
        Set oRs = New ADODB.Recordset
        oRs.CursorLocation = adUseClient
        oRs.CursorType = adOpenStatic
        oRs.LockType = adLockReadOnly
         
         
        ' -----------------------------------------------
        ' Force natural (not alphabetical) order of fields.
        ' -----------------------------------------------
        Set oRs = SourceDataBase.OpenSchema(adSchemaColumns, _
                                            Array(Empty, Empty, oCat.Tables(QueryOrTableName).Name) _
                                           )
         
         Dim nThisColumn As Integer
         
         For i = 0 To nColumnCount
           
          oRs.MoveFirst
          oRs.Find "ORDINAL_POSITION=" & CLng(i + 1), , adSearchForward
           
           With oCat.Tables(QueryOrTableName).Columns(oRs("COLUMN_NAME").Value)
            
            ''''''''''''''''''''''''''
            'Microsoft Jet data types
            ''''''''''''''''''''''''''
            'Bit
            'Byte                       0      to        255
            'Short                 -32768      to      32767
            'Long             -2147483648      to 2147483647
            'Currency    -922337203685477.5808 to 922337203685477.5807
            'Single     Positive values:  1.401298E-45 (53) to  3.402823E38 (39)
            '           Negative values: -3.402823E38  (40) to -1.401298E-45 (54)
            'Double     Positive values:  4.94065645841247E-324 to 1.79769313486232E308
            '           Negative values: -1.79769313486232E308 to -4.94065645841247E-324
            'DateTime
            'Text
            'Memo
            
            '''''''''''''''''''
            'ODBC data types
            '''''''''''''''''''
            'Char (same as Text)
            'Float (same as Double)
            'Integer (same as Short)
            'LongChar (same as Memo)
            'Date date format

            'Access field   DataTypeEnum       Value      SCHEMA.INI
            'Integer      = adSmallInt        =  2    --->Short Width 6
            'AutoNumber   = adInteger         =  3    --->Long Width 11
            'Long Integer = adInteger         =  3    --->Long Width 11
            'Single       = adSingle          =  4    --->Single
            'Decimal      = adNumeric         =131    --->Single Width 13
            '               Integers: +/-79,228,162,514,264,337,593,543,950,335 (30 digits)
            '               Decimals: +/-7.9228162514264337593543950335         (28 decimal places)
            'Double       = adDouble          =  5    --->Double
            'Date/Time    = adDate            =  7    --->DateTime
            'Yes/No       = adBoolean         = 11    --->Bit Width 1
            'Byte         = adUnsignedTinyInt = 17    --->Byte Width 3
            'Replication  = adGUID            = 72    --->Text Width 38
            'Lookup       = adVarWChar        =202    --->Text
            'Text         = adVarWChar        =202    --->Text
            'Memo         = adLongVarWChar    =203    --->Memo
            'Hyperlink    = adLongVarWChar    =203    --->Memo
            'OLE          = adLongVarBinary   =205    ---> IGNORE

           fldDataInfo = ""
           Select Case .Type
                     
                     Case adBoolean                         ' Yes/No field
                        fldDataInfo = "Bit Width 1"         ' 0 to 1
                     
                     Case adUnsignedTinyInt                 ' Byte
                        fldDataInfo = "Byte Width 3"        ' 0 to 255
                     
                     Case adSmallInt                        ' Integer
                        fldDataInfo = "Short Width 6"       ' -32768 to 32767
                     
                     Case adInteger                         ' AutoNumber/Long Integer
                        fldDataInfo = "Long Width 11"       '"Integer Width 6"     ' -2147483648 to 2147483647
                     
                     Case adCurrency                        ' Currency
                        ' The maximum length of Currency fields:
                        ' (-922,337,203,685,477.5088 SKr) = 31
                        fldDataInfo = "Currency Width 31"   ' -922337203685477.5808 to 922337203685477.5807
                     
                     Case adSingle, adNumeric               ' Single/Decimal
                        fldDataInfo = "Single Width 13"     ' -3.402823E38 to -1.401298E-45 for negative values;
                                                            '  1.401298E-45 to 3.402823E38 for positive values
                     Case adDouble
                        fldDataInfo = "Double Width 22"     ' -1.79769313486232E308 to -4.94065645841247E-324 for negative values;
                                                            '  4.94065645841247E-324 to 1.79769313486232E308 for positive values
                     Case adDate
                        fldDataInfo = "DateTime Width " & Len(DateTimeFormat)   '"Date Width " & Len(DateTimeFormat)
                     
                     Case adVarWChar                        ' Lookup/Text
                        fldDataInfo = "Text Width " & Format$(.DefinedSize) '"Char Width " & Format$(.DefinedSize)
                     
                     Case adLongVarBinary                   ' OLE
                      ' NOT exportable!
                     
                     Case adLongVarWChar                    ' Memo
                        fldDataInfo = "Memo Width 255"      '"LongChar Width 255"
                     
                     Case adGUID                            ' Replication ID
                        fldDataInfo = "Text Width 38"       '"Char Width 38"
           
           End Select
            
            If fldDataInfo <> "" Then

             fldName = .Name
             nThisColumn = nThisColumn + 1
             cSelect = cSelect & "[" & fldName & "]" ' & ","
            
            ' The SCHEMA.INI is allergic to:
            ' 1) Periods "."
            '    which may occur in fully qualified field names
            '    like "Customer.ID" found in Access Views/Queries
            '    and the column headings (field names) of Excel tables;
            '    the original column header may contain a "." as in
            '    "Sales Over DM 10.00"; the column name in the ADOX
            '    catalog will be "Sales Over DM 10#00"
            
            ' 2) Table/field names with blanks:
             
             If InStr(fldName, ".") <> 0 Or _
                InStr(fldName, " ") <> 0 Then
                fldName = Replace(fldName, ".", "")
                fldName = Replace(fldName, " ", "_")
                fldName = Replace(fldName, "#", "")
                cSelect = cSelect & " AS " & fldName
             End If
             cSelect = cSelect & ","
             
             Print #Handle, "Col" & Format$(nThisColumn) _
                             & "=" & fldName & Space$(1) _
                             & fldDataInfo
           
            End If
           End With
           
         
         
         Next
         Close Handle
         oRs.Close
         Set oRs = Nothing
         


 ' -----------------------------------------------
 ' Generate the SQL statement:
 ' -----------------------------------------------
   If cSelect <> "" Then
        cSelect = Left(cSelect, Len(cSelect) - 1)

        cSelect = "SELECT " & cSelect & " " & vbCrLf & _
                  "INTO [" & _
                         IIf(FileDelimiterType <> dtHTML, "Text;", "HTML Export;") & _
                        "Database=" & TextDataBasePath & _
                       "]." & _
                       "[" & _
                         TableName & _
                         IIf(FileDelimiterType <> dtHTML, ".txt", ".htm") & _
                       "] " & vbCrLf & _
                  "FROM [" & QueryOrTableName & "]"

   End If

' return the SQL statement


CreateExportSQL = cSelect


End Function
